/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.session;

import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.log.LogLevel;

import java.util.ArrayList;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 26/08/2015
 */
public class DDMUserProfile extends AbstractDDMUserProfile
{

    /**
     * Default constructor without initialization context.<br/>
     * NOT FOR USE outside the DDM API classes as it may be removed in next releases
     */
    public DDMUserProfile()
    {
        super();
    }

    /**
     * Default constructor
     *
     * @param session the current session
     *
     * @exception IdentityManagerException
     */
    public DDMUserProfile(IDIFSession session) throws IdentityManagerException
    {
        this.setInstanceIDs(session.isLogged() ? new ArrayList<String>(session.getUser().getGroupIDs()) : null);
    }

    /**
     * @see pt.digitalis.dif.dataminer.session.IDDMUserProfile#getDescription(java.lang.String, java.lang.String)
     */
    public String getDescription(String instanceID, String languageID)
    {
        return this.getMessageFromApplicationMessages("ddm", "description", instanceID, languageID);
    }

    /**
     * @see pt.digitalis.dif.dataminer.session.IDDMUserProfile#getInstanceIDBusinessDescription(java.lang.String)
     */
    public String getInstanceIDBusinessDescription(String profileInstanceID)
    {
        try
        {
            return DIFIoCRegistry.getRegistry().getImplementation(IIdentityManager.class).getGroup(profileInstanceID)
                    .getName();
        }
        catch (IdentityManagerException e)
        {
            new BusinessException("Error while determining the description for the DDM user profile " + this.getID(), e)
                    .addToExceptionContext("DDMUserProfile", this)
                    .addToExceptionContext("instanceID", profileInstanceID).log(LogLevel.ERROR);

            return null;
        }
    }

    /**
     * @see pt.digitalis.dif.dataminer.session.IDDMUserProfile#getName(java.lang.String, java.lang.String)
     */
    public String getName(String instanceID, String languageID)
    {
        return this.getMessageFromApplicationMessages("ddm", "name", instanceID, languageID);
    }

    /**
     * @see pt.digitalis.dif.dataminer.session.IDDMUserProfile#getProfileInstanceDescriptionOnly(java.lang.String,
     *         java.lang.String)
     */
    public String getProfileInstanceDescriptionOnly(String instanceID, String languageID)
    {
        return null;
    }

    /**
     * @see pt.digitalis.dif.dataminer.session.IDDMUserProfile#getProfileNameOnly(java.lang.String, java.lang.String)
     */
    public String getProfileNameOnly(String instanceID, String languageID)
    {
        return this.getName(instanceID, languageID);
    }

    /**
     * @see pt.digitalis.dif.dataminer.session.IDDMUserProfile#isAllowUserToSelectInstance()
     */
    public boolean isAllowUserToSelectInstance()
    {
        return false;
    }
}
