/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 19/10/2016
 */
@ConfigID("dif2")
@ConfigSectionID("DataMiner")
public class DDMConfiguration
{

    /** The singleton instance property */
    private static DDMConfiguration instance;

    /** The error page for an inexistent stage */
    private String sqlEditorHelpTemplate;

    /**
     * Returns the active configuration object instance.
     *
     * @return the configuration instance
     */
    @ConfigIgnore
    static public DDMConfiguration getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(DDMConfiguration.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /**
     * Inspector for the 'sqlEditorHelpTemplate' attribute.
     *
     * @return the sqlEditorHelpTemplate value
     */
    @ConfigDefault("templates/indicatorHelp.html")
    public String getSqlEditorHelpTemplate()
    {
        return sqlEditorHelpTemplate;
    }

    /**
     * Modifier for the 'sqlEditorHelpTemplate' attribute.
     *
     * @param sqlEditorHelpTemplate the new sqlEditorHelpTemplate value to set
     */
    public void setSqlEditorHelpTemplate(String sqlEditorHelpTemplate)
    {
        this.sqlEditorHelpTemplate = sqlEditorHelpTemplate;
    }
}
