/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.definition;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.utils.annotations.JSONIgnore;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;

import java.util.Map;

/**
 * A filter definition for indicators
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 5 de Mar de 2013
 */
public class Filter
{

    /**
     *
     */
    private String bindToProfileID;

    /** the filter dataset description key in the call to get the options list */
    private String dataSetDescField;

    /** the filter default value if any */
    private String defaultValue;

    /** the filter description */
    private String description;

    /** the filter dataset to call to get the options list */
    private IDataSet<? extends IBeanAttributes> filterDataset;

    /** the filter expression SQL template with the ":value" contained keyword */
    private String filterSQLTemplate;

    /** the filter ID */
    private String id;

    /**
     * the filter LOV items in key value format. The key (value to select and apply to the main SQL query) and value
     * (the description to show in selection and descriptions) fields
     */
    private Map<String, String> lovItems;

    /**
     * the filter LOV SQL. Must contain a key (value to select and apply to the main SQL query) and value (the
     * description to show in selection and descriptions) fields
     */
    private String lovQuerySQL;

    /** the filter title */
    private String title;

    /** the filter type */
    private FilterType type = FilterType.TEXT;

    /**
     * Default constructor
     *
     * @param id
     * @param type
     * @param title
     * @param description
     * @param filterSQLTemplate
     */
    public Filter(String id, FilterType type, String title, String description, String filterSQLTemplate)
    {
        this(id, type, title, description, filterSQLTemplate, null);
    }

    /**
     * Default constructor
     *
     * @param id
     * @param type
     * @param title
     * @param description
     * @param filterSQLTemplate
     * @param defaultValue
     */
    public Filter(String id, FilterType type, String title, String description, String filterSQLTemplate,
            String defaultValue)
    {
        super();
        this.id = id;
        this.type = type;
        this.title = title;
        this.description = description;
        this.filterSQLTemplate = filterSQLTemplate;
        this.defaultValue = defaultValue;
    }

    /**
     * LOV Filter constructor
     *
     * @param id
     * @param title
     * @param description
     * @param filterSQLTemplate
     * @param filterDataset
     * @param dataSetDescField
     */
    public Filter(String id, String title, String description, String filterSQLTemplate,
            IDataSet<? extends IBeanAttributes> filterDataset, String dataSetDescField)
    {
        this(id, title, description, filterSQLTemplate, filterDataset, dataSetDescField, null);
    }

    /**
     * LOV Filter constructor
     *
     * @param id
     * @param title
     * @param description
     * @param filterSQLTemplate
     * @param filterDataset
     * @param dataSetDescField
     * @param defaultValue
     */
    public Filter(String id, String title, String description, String filterSQLTemplate,
            IDataSet<? extends IBeanAttributes> filterDataset, String dataSetDescField, String defaultValue)
    {
        super();
        this.id = id;
        this.title = title;
        this.description = description;
        this.type = FilterType.LOV;
        this.filterSQLTemplate = filterSQLTemplate;
        this.filterDataset = filterDataset;
        this.dataSetDescField = dataSetDescField;
        this.defaultValue = defaultValue;
    }

    /**
     * LOV Filter constructor
     *
     * @param id
     * @param title
     * @param description
     * @param filterSQLTemplate
     * @param lovItems
     */
    public Filter(String id, String title, String description, String filterSQLTemplate, Map<String, String> lovItems)
    {
        this(id, title, description, filterSQLTemplate, lovItems, null);
    }

    /**
     * LOV Filter constructor
     *
     * @param id
     * @param title
     * @param description
     * @param filterSQLTemplate
     * @param lovItems
     * @param defaultValue
     */
    public Filter(String id, String title, String description, String filterSQLTemplate, Map<String, String> lovItems,
            String defaultValue)
    {
        super();
        this.id = id;
        this.title = title;
        this.description = description;
        this.type = FilterType.LOV;
        this.filterSQLTemplate = filterSQLTemplate;
        this.lovItems = lovItems;
        this.lovQuerySQL = null;
        this.defaultValue = defaultValue;
    }

    /**
     * LOV Filter constructor
     *
     * @param id
     * @param title
     * @param description
     * @param filterSQLTemplate
     * @param lovQuerySQL
     */
    public Filter(String id, String title, String description, String filterSQLTemplate, String lovQuerySQL)
    {
        this(id, title, description, filterSQLTemplate, lovQuerySQL, null);
    }

    /**
     * LOV Filter constructor
     *
     * @param id
     * @param title
     * @param description
     * @param filterSQLTemplate
     * @param lovQuerySQL
     * @param defaultValue
     */
    public Filter(String id, String title, String description, String filterSQLTemplate, String lovQuerySQL,
            String defaultValue)
    {
        super();
        this.id = id;
        this.title = title;
        this.description = description;
        this.type = FilterType.LOV;
        this.filterSQLTemplate = filterSQLTemplate;
        this.lovQuerySQL = lovQuerySQL;
        this.defaultValue = defaultValue;
    }

    /**
     * Inspector for the 'bindToProfileID' attribute.
     *
     * @return the bindToProfileID value
     */
    public String getBindToProfileID()
    {
        return bindToProfileID;
    }

    /**
     * Modifier for the 'bindToProfileID' attribute.
     *
     * @param bindToProfileID the new bindToProfileID value to set
     *
     * @return the updated object
     */
    public Filter setBindToProfileID(String bindToProfileID)
    {
        this.bindToProfileID = bindToProfileID;

        return this;
    }

    /**
     * Inspector for the 'dataSetDescField' attribute.
     *
     * @return the dataSetDescField value
     */
    public String getDataSetDescField()
    {
        return dataSetDescField;
    }

    /**
     * Modifier for the 'dataSetDescField' attribute.
     *
     * @param dataSetDescField the new dataSetDescField value to set
     */
    public void setDataSetDescField(String dataSetDescField)
    {
        this.dataSetDescField = dataSetDescField;
    }

    /**
     * Inspector for the 'defaultValue' attribute.
     *
     * @return the defaultValue value
     */
    public String getDefaultValue()
    {
        return defaultValue;
    }

    /**
     * Modifier for the 'defaultValue' attribute.
     *
     * @param defaultValue the new defaultValue value to set
     */
    public void setDefaultValue(String defaultValue)
    {
        this.defaultValue = defaultValue;
    }

    /**
     * Inspector for the 'description' attribute.
     *
     * @return the description value
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Modifier for the 'description' attribute.
     *
     * @param description the new description value to set
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * Inspector for the 'filterDataset' attribute.
     *
     * @return the filterDataset value
     */
    public IDataSet<? extends IBeanAttributes> getFilterDataset()
    {
        return filterDataset;
    }

    /**
     * Modifier for the 'filterDataset' attribute.
     *
     * @param filterDataset the new filterDataset value to set
     */
    public void setFilterDataset(IDataSet<IBeanAttributes> filterDataset)
    {
        this.filterDataset = filterDataset;
    }

    /**
     * Inspector for the 'filterSQLTemplate' attribute.
     *
     * @return the filterSQLTemplate value
     */
    public String getFilterSQLTemplate()
    {
        return filterSQLTemplate;
    }

    /**
     * Modifier for the 'filterSQLTemplate' attribute.
     *
     * @param filterSQLTemplate the new filterSQLTemplate value to set
     */
    public void setFilterSQLTemplate(String filterSQLTemplate)
    {
        this.filterSQLTemplate = filterSQLTemplate;
    }

    /**
     * Inspector for the 'id' attribute.
     *
     * @return the id value
     */
    public String getId()
    {
        return id;
    }

    /**
     * Modifier for the 'id' attribute.
     *
     * @param id the new id value to set
     */
    public void setId(String id)
    {
        this.id = id;
    }

    /**
     * Inspector for the 'lovItems' attribute.
     *
     * @return the lovItems value
     */
    public Map<String, String> getLovItems()
    {
        return lovItems;
    }

    /**
     * Modifier for the 'lovItems' attribute.
     *
     * @param lovItems the new lovItems value to set
     */
    public void setLovItems(Map<String, String> lovItems)
    {
        this.lovItems = lovItems;
    }

    /**
     * Inspector for the 'lovQuerySQL' attribute.
     *
     * @return the lovQuerySQL value
     */
    public String getLovQuerySQL()
    {
        return lovQuerySQL;
    }

    /**
     * Modifier for the 'lovQuerySQL' attribute.
     *
     * @param lovQuerySQL the new lovQuerySQL value to set
     */
    public void setLovQuerySQL(String lovQuerySQL)
    {
        this.lovQuerySQL = lovQuerySQL;
    }

    /**
     * Inspector for the 'title' attribute.
     *
     * @return the title value
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * Modifier for the 'title' attribute.
     *
     * @param title the new title value to set
     */
    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * Inspector for the 'type' attribute.
     *
     * @return the type value
     */
    public FilterType getType()
    {
        return type;
    }

    /**
     * Modifier for the 'type' attribute.
     *
     * @param type the new type value to set
     */
    public void setType(FilterType type)
    {
        this.type = type;
    }

    /**
     * @return dummy method to prevent JSON conversion warning of no setter method polluting the log
     */
    @JSONIgnore
    private Map<String, String> getValues()
    {
        // Not implemented
        return null;
    }

    /**
     * Sets several values given in the key/values form
     *
     * @param attrs
     */
    public void setValues(Map<String, String> attrs)
    {
        if (attrs.containsKey("id"))
            this.setId(attrs.get("id"));
        if (attrs.containsKey("title"))
            this.setTitle(attrs.get("title"));
        if (attrs.containsKey("description"))
            this.setDescription(attrs.get("description"));
        if (attrs.containsKey("bindToProfileID"))
            this.setBindToProfileID(attrs.get("bindToProfileID"));
        if (attrs.containsKey("dataSetDescField"))
            this.setDataSetDescField(attrs.get("dataSetDescField"));
        if (attrs.containsKey("filterSQLTemplate"))
            this.setFilterSQLTemplate(attrs.get("filterSQLTemplate"));
        if (attrs.containsKey("lovQuerySQL"))
            this.setLovQuerySQL(attrs.get("lovQuerySQL"));
        if (attrs.containsKey("lovItems"))
            this.setLovItems(CollectionUtils.stringToKeyValueMap(attrs.get("lovItems")));
        if (attrs.containsKey("type") && StringUtils.isNotBlank(attrs.get("type")))
            this.setType(FilterType.valueOf(attrs.get("type")));
    }
}
