package pt.digitalis.dif.translator.exception;

/**
 * Exception for Translator <br>
 *
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Dec 23, 2009
 */
public class TranslatorException extends Exception {

    /** Message for a value declared in dictionary, but with no value translation */
    public static final String TRANSLATION_VALUE_NOT_FOUND = "Field #key# has dictionary, but now translation for value #value#";

    /**
     * Serial version ID
     */
    private static final long serialVersionUID = 436290834234234L;

    /**
     * @param message
     *            the message for exception
     */
    public TranslatorException(String message)
    {
        super(message);
    }

    /**
     * Constructs a new exception with a message and a cause.
     *
     * @param message
     *            the exception message
     * @param cause
     *            the exception cause
     */
    public TranslatorException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new exception with a cause.
     *
     * @param cause
     *            the exception cause
     */
    public TranslatorException(Throwable cause) {
        super(cause);
    }

}
