package pt.digitalis.dif.dem.managers.impl.audit.model;

import org.hibernate.LobHelper;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;

import pt.digitalis.dif.model.hibernate.HibernateUtil;

/**
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class DIFDBAuditFactory {

	/** The session factory name. */
    public static String SESSION_FACTORY_NAME = "DIFDBAudit";

    /**
     * Obtains the current session Configuration
     * 
     * @return the Configuration object
     */
    static public Configuration getConfiguration()
    {
        return HibernateUtil.getDatabaseConfiguration(SESSION_FACTORY_NAME, null);
    }

    /**
     * Gets the lob helper.
     *
     * @return the lob helper
     */
    public static LobHelper getLobHelper()
    {
        boolean wasActive = openTransaction();

        LobHelper result = DIFDBAuditFactory.getSession().getLobHelper();

        if (!wasActive)
        {
            DIFDBAuditFactory.getSession().getTransaction().commit();
        }

        return result;
    }

	/**
	 * Obtains the current session
	 *
	 * @return the session object
	 */
    static public Session getSession() 
    {
    	return HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
    }
    
    /**
     * Sets the session factory name.
     * 
     * @param name
     *            the new session factory name
     */
    public static void setSessionFactoryName(String name)
    {
        SESSION_FACTORY_NAME = name;
    }
    
   /**
     * Open transaction. Checks if there are a transaction is active
     *
     * @return true, if the there was a already active transaction
     */
    public static boolean openTransaction()
    {
        boolean wasActive = DIFDBAuditFactory.getSession().getTransaction().isActive();

        if (!wasActive)
        {
            DIFDBAuditFactory.getSession().beginTransaction();
        }
        return wasActive;
    }
}