package pt.digitalis.dif.dem.managers.impl.audit.ioc;

import pt.digitalis.dif.controller.interfaces.IModelManager;
import pt.digitalis.dif.dem.managers.impl.audit.model.DIFAuditDBModelManager;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * The type Audit module.
 */
public class AuditModule implements IIoCModule
{

    /**
     * Configure.
     *
     * @param binder the binder
     *
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     *         pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    @Override
    public void configure(IoCBinder binder)
    {
        binder.bind(IModelManager.class, DIFAuditDBModelManager.class).withId(DIFAuditDBModelManager.MODEL_ID);
    }
}