package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.PersistentForm;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class PersistentForm.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.PersistentForm
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoPersistentFormDAO extends IHibernateDAO<PersistentForm> {

    /**
     * Obtains a new DataSet for the PersistentForm entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<PersistentForm> getPersistentFormDataSet();

	/**
	 * Persist a PersistentForm object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(PersistentForm transientInstance);

	/**
	 * Updates a modified PersistentForm in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(PersistentForm instance);

	/**
	 * Attach an unmodified PersistentForm instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(PersistentForm instance);

	/**
	 * Removes a PersistentForm instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(PersistentForm persistentInstance);

	/**
	 * Merge a PersistentForm instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public PersistentForm merge(PersistentForm detachedInstance);

	/**
	 * Finds a PersistentForm instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public PersistentForm findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<PersistentForm> findAll();


	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentForm> findByFieldParcial(PersistentForm.Fields field, String value);

	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than match the formId attribute with the given value
	 *
	 * @param formId to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentForm> findByFormId(String formId);

	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than match the disabledFields attribute with the given value
	 *
	 * @param disabledFields to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentForm> findByDisabledFields(String disabledFields);

	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than match the fieldDefs attribute with the given value
	 *
	 * @param fieldDefs to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentForm> findByFieldDefs(String fieldDefs);
}
