/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.ecommerce;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.hibernate.exception.ConstraintViolationException;
import pt.digitalis.dif.dem.managers.impl.model.IECommerceService;
import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.ecommerce.BusinessProcessResult;
import pt.digitalis.dif.ecommerce.IECommerce;
import pt.digitalis.dif.ecommerce.IECommerceBusiness;
import pt.digitalis.dif.ecommerce.PaymentException;
import pt.digitalis.dif.ecommerce.PaymentExecutionResult;
import pt.digitalis.dif.ecommerce.PaymentRequest;
import pt.digitalis.dif.ecommerce.PaymentStatus;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractECommerce<T>
implements IECommerce<T> {
    public static String MESSAGE_SEPARATOR = "#SEP#";
    protected static final String PAYMENT_AMOUNT_CHANGED_MSG = "The payment amount received is different from the original request.";
    protected static final String PAYMENT_BUSINESS_PROCESSOR_FAILED = "The payment business proccess [\"#1\"] failed.";
    protected static final String PAYMENT_BUSINESS_PROCESSOR_WARNING = "The payment business proccess [\"#1\"] has warnings.";
    protected static final String PAYMENT_INIT_ERROR = "The payment was not initialized. Process aborted.";
    protected static final String PAYMENT_TOKEN_CHANGED_MSG = "The payment token received is different from the original request.";
    public static final String UNIQUE_ID_SEPARATOR = "-";
    IECommerceService eCommerceService = (IECommerceService)DIFIoCRegistry.getRegistry().getImplementation(IECommerceService.class);

    public static String verifyMessage(String newMessage, String statusMessage) {
        String result = statusMessage;
        if (result != null) {
            if (result.contains(newMessage)) {
                result = result.replace(newMessage, "");
            }
            if ((result = String.valueOf(result) + newMessage).length() >= 3999) {
                int position = result.lastIndexOf(newMessage);
                result = result.substring(position - 400, position - 1);
            }
        }
        return result;
    }

    public abstract PaymentExecutionResult<T> doInit(PaymentRequest var1, String var2, String var3);

    public abstract PaymentExecutionResult<T> doProcess(String var1, String var2, String var3, T var4);

    private String getNextID(String partialBusinessId) throws DataSetException {
        String result = "";
        Query query = this.eCommerceService.getEcommercePaymentsDataSet().query();
        query.addFilter(new Filter("businessId".toString(), FilterType.LIKE, partialBusinessId));
        Long seq = query.count();
        result = String.valueOf(partialBusinessId) + UNIQUE_ID_SEPARATOR + (seq + 1L);
        return result;
    }

    private EcommercePayments getPaymentRecord(String businessId) throws DataSetException {
        Query query = this.eCommerceService.getEcommercePaymentsDataSet().query();
        query.addFilter(new Filter("businessId".toString(), FilterType.EQUALS, businessId));
        return (EcommercePayments)query.singleValue();
    }

    @Override
    public final EcommercePayments initWebPayment(PaymentRequest payment, String partialBusinessId) throws PaymentException {
        return this.initWebPayment(payment, partialBusinessId, null);
    }

    @Override
    public EcommercePayments initWebPayment(PaymentRequest payment, String partialBusinessId, String configurationId) throws PaymentException {
        EcommercePayments ePaymentRecord = null;
        ePaymentRecord = new EcommercePayments();
        ePaymentRecord.setBusinessContext(payment.getBusinessContext());
        ePaymentRecord.setCreator(payment.getCreator());
        ePaymentRecord.setDateCreation(new Timestamp(new Date().getTime()));
        ePaymentRecord.setEcommerceProcessor(this.getIdentifier());
        ePaymentRecord.setPaymentValue(payment.getAmount());
        ePaymentRecord.setConfigurationId(configurationId);
        ePaymentRecord.setStatus(PaymentStatus.F.name());
        boolean inserted = false;
        while (!inserted) {
            try {
                String id = this.getNextID(partialBusinessId);
                ePaymentRecord.setBusinessId(id);
                ePaymentRecord = (EcommercePayments)this.eCommerceService.getEcommercePaymentsDataSet().insert((IBeanAttributes)ePaymentRecord);
                inserted = true;
            }
            catch (Exception e) {
                boolean uniqueKeyException = false;
                if (e instanceof ConstraintViolationException) {
                    ConstraintViolationException constraintViolation = (ConstraintViolationException)e.getCause();
                    uniqueKeyException = constraintViolation.getConstraintName().toUpperCase().endsWith(".EPAYMENTRECORD_BUSINESS_ID_UK");
                }
                if (uniqueKeyException) continue;
                throw new PaymentException(e);
            }
        }
        PaymentExecutionResult<T> paymentResult = this.doInit(payment, ePaymentRecord.getBusinessId(), configurationId);
        if (paymentResult.isSuccess()) {
            ePaymentRecord.setSecurityToken(paymentResult.getSecurityToken());
            ePaymentRecord.setRedirectUrl(paymentResult.getRedirectURL());
            ePaymentRecord.setTransactionId(paymentResult.getTransactionId());
            String message = "doInit: Payment '" + ePaymentRecord.getBusinessId() + "' initialized.";
            if (paymentResult.getMessage() != null) {
                message = String.valueOf(message) + " Message:" + paymentResult.getMessage();
            }
            ePaymentRecord.setStatusMessage(message);
            ePaymentRecord.setStatus(PaymentStatus.W.name());
            try {
                ePaymentRecord = (EcommercePayments)this.eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
            }
            catch (DataSetException e) {
                throw new PaymentException((Exception)((Object)e));
            }
        }
        String errorMessage = paymentResult.getMessage() == null ? PAYMENT_INIT_ERROR : "The payment was not initialized. Process aborted.\n   Reason: " + paymentResult.getMessage();
        try {
            ePaymentRecord.setStatusMessage(errorMessage);
            ePaymentRecord = (EcommercePayments)this.eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
        }
        catch (DataSetException e) {
            throw new PaymentException((Exception)((Object)e));
        }
        throw new PaymentException(errorMessage);
        return ePaymentRecord;
    }

    @Override
    public final EcommercePayments processBusinessPayment(EcommercePayments ePaymentRecord) throws PaymentException {
        try {
            IECommerceBusiness business;
            String statusMessage = StringUtils.nvl((String)ePaymentRecord.getStatusMessage(), (String)"");
            List list = DIFIoCRegistry.getRegistry().getImplementations(IECommerceBusiness.class);
            Boolean markAsProcessed = true;
            Boolean updateRecord = false;
            if (!list.isEmpty() && (business = (IECommerceBusiness)list.get(0)) != null) {
                String businessMessage = "";
                try {
                    BusinessProcessResult processResult = business.processPayment(ePaymentRecord);
                    if (!processResult.isSuccess().booleanValue()) {
                        markAsProcessed = false;
                    }
                    businessMessage = processResult.getMessage();
                }
                catch (Exception e) {
                    businessMessage = " " + e.getMessage();
                    markAsProcessed = false;
                }
                if (!markAsProcessed.booleanValue()) {
                    String newMessage = String.valueOf(MESSAGE_SEPARATOR) + PAYMENT_BUSINESS_PROCESSOR_FAILED.replace("#1", business.getFullIdentifier()) + ": " + businessMessage;
                    statusMessage = AbstractECommerce.verifyMessage(newMessage, statusMessage);
                    ePaymentRecord.setStatusMessage(statusMessage.trim());
                    updateRecord = true;
                } else if (businessMessage != null && !"".equals(businessMessage)) {
                    statusMessage = String.valueOf(statusMessage) + MESSAGE_SEPARATOR + PAYMENT_BUSINESS_PROCESSOR_WARNING.replace("#1", business.getFullIdentifier()) + ": " + businessMessage;
                    updateRecord = true;
                    ePaymentRecord.setStatusMessage(statusMessage.trim());
                }
            }
            if (markAsProcessed.booleanValue()) {
                ePaymentRecord.setStatus(PaymentStatus.P.name());
                ePaymentRecord.setDateProcessed(new Timestamp(new Date().getTime()));
                updateRecord = true;
            }
            if (updateRecord.booleanValue()) {
                ePaymentRecord = (EcommercePayments)this.eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
            }
        }
        catch (DataSetException e) {
            throw new PaymentException((Exception)((Object)e));
        }
        return ePaymentRecord;
    }

    @Override
    public EcommercePayments processWebPayment(String businessID) throws PaymentException {
        return this.processWebPayment(businessID, null, null);
    }

    @Override
    public final EcommercePayments processWebPayment(String businessID, String securityToken, T providerResponse) throws PaymentException {
        EcommercePayments ePaymentRecord = null;
        try {
            ePaymentRecord = this.getPaymentRecord(businessID);
            if (ePaymentRecord == null) {
                throw new PaymentException("The requested payment wasn't found. The payment ID is \"" + businessID + "\"");
            }
            String statusMessage = StringUtils.nvl((String)ePaymentRecord.getStatusMessage(), (String)"");
            if (!PaymentStatus.W.name().equals(ePaymentRecord.getStatus())) {
                throw new PaymentException("The requested payment has allready been processed. The payment ID is \"" + businessID + "\"");
            }
            PaymentExecutionResult paymentExecutionResult = new PaymentExecutionResult();
            if (ePaymentRecord.getSecurityToken() == null || ePaymentRecord.getSecurityToken().equals(securityToken) || securityToken == null) {
                if (securityToken == null) {
                    securityToken = ePaymentRecord.getSecurityToken();
                }
                paymentExecutionResult = this.doProcess(businessID, securityToken, ePaymentRecord.getConfigurationId(), providerResponse);
                statusMessage = String.valueOf(statusMessage) + MESSAGE_SEPARATOR + " doProcess ";
            } else {
                statusMessage = String.valueOf(statusMessage) + " The payment token received is different from the original request.";
            }
            if (ePaymentRecord.getSecurityToken() == null && paymentExecutionResult.getSecurityToken() != null) {
                ePaymentRecord.setSecurityToken(paymentExecutionResult.getSecurityToken());
            }
            if (paymentExecutionResult.isSuccess()) {
                statusMessage = String.valueOf(statusMessage) + " Success ";
                if (paymentExecutionResult.getMessage() != null) {
                    statusMessage = String.valueOf(statusMessage) + paymentExecutionResult.getMessage();
                }
                paymentExecutionResult.setBusinessContext(ePaymentRecord.getBusinessContext());
                if (paymentExecutionResult.getAmmount().compareTo(ePaymentRecord.getPaymentValue()) != 0) {
                    statusMessage = String.valueOf(statusMessage) + MESSAGE_SEPARATOR + PAYMENT_AMOUNT_CHANGED_MSG;
                }
                ePaymentRecord.setStatusMessage(StringUtils.nvl((String)statusMessage, (String)"").trim());
                ePaymentRecord.setStatus(PaymentStatus.R.name());
                ePaymentRecord.setTransactionId(paymentExecutionResult.getTransactionId());
                ePaymentRecord.setTransactionDate(new Timestamp(paymentExecutionResult.getTransactionDate().getTime()));
                ePaymentRecord.setDateReceived(new Timestamp(new Date().getTime()));
                ePaymentRecord.setPaymentValue(paymentExecutionResult.getAmmount());
                ePaymentRecord.setAuthorizationId(paymentExecutionResult.getAuthorizationId());
                ePaymentRecord = (EcommercePayments)this.eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
                ePaymentRecord = this.processBusinessPayment(ePaymentRecord);
            } else {
                if (paymentExecutionResult.getMessage() != null) {
                    String newMessage = String.valueOf(MESSAGE_SEPARATOR) + paymentExecutionResult.getMessage();
                    statusMessage = AbstractECommerce.verifyMessage(newMessage, statusMessage);
                }
                ePaymentRecord.setStatusMessage(statusMessage.trim());
                if (paymentExecutionResult.isPaymentFailed()) {
                    ePaymentRecord.setStatus(PaymentStatus.F.name());
                    ePaymentRecord.setDateReceived(new Timestamp(new Date().getTime()));
                }
                ePaymentRecord = (EcommercePayments)this.eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
            }
        }
        catch (DataSetException e) {
            throw new PaymentException(e.getMessage());
        }
        return ePaymentRecord;
    }
}

