DELIMITER $$
USE `mobilidadenet` ;
$$
CREATE TABLE IF NOT EXISTS `AUDIT_LOG` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary key',
  `app` varchar(30)  NOT NULL COMMENT 'The application name',
  `userid` varchar(100)  NOT NULL COMMENT 'The user ID',
  `entity_name` varchar(200)  NOT NULL COMMENT 'The entity (table) name changed',
  `operation` enum('C','U','D')  NOT NULL COMMENT 'The issued operation ',
  `operation_date` datetime NOT NULL COMMENT 'The date the operation took place',
  `instance_id` varchar(200)  DEFAULT NULL COMMENT 'The instance ID (PK) of the operation',
  PRIMARY KEY (`ID`),
  KEY `AUDIT_LOG_ENTITY_IDX` (`entity_name`,`operation_date`),
  KEY `AUDIT_LOG_DATE_IDX` (`operation`,`entity_name`),
  KEY `AUDIT_LOG_IDX` (`app`,`entity_name`,`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
$$

CREATE TABLE IF NOT EXISTS `AUDIT_LOG_DETAIL` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary key',
  `audit_log_id` int(11) NOT NULL COMMENT 'The audit log main entry id',
  `column_name` varchar(200)  NOT NULL COMMENT 'The changed column name in the operation',
  `previous_value` varchar(4000)  DEFAULT NULL COMMENT 'The previous value',
  `new_value` varchar(4000)  DEFAULT NULL COMMENT 'The new value',
  PRIMARY KEY (`ID`),
  KEY `AUDIT_LOG_DETAIL_LOG_FK_idx` (`audit_log_id`),
  CONSTRAINT `AUDIT_LOG_DETAIL_LOG_FK` FOREIGN KEY (`audit_log_id`) REFERENCES `AUDIT_LOG` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
$$