package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Groups;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoGroupsDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Groups.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Groups
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoGroupsDAOImpl implements IAutoGroupsDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Groups entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Groups> getGroupsDataSet()
    {
        return new HibernateDataSet<Groups>(Groups.class, this, Groups.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoGroupsDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Groups object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Groups transientInstance) {
        logger.debug("persisting Groups instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Groups in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Groups instance) {
        logger.debug("attaching dirty Groups instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Groups instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Groups instance) {
        logger.debug("attaching clean Groups instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Groups instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Groups persistentInstance) {
        logger.debug("deleting Groups instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Groups instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Groups merge(Groups detachedInstance) {
        logger.debug("merging Groups instance");
        Groups result = (Groups) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Groups instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Groups findById( java.lang.String id) {
        logger.debug("getting Groups instance with id: " + id);
        Groups instance = (Groups) getSession()
                .get(Groups.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Groups instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Groups> findAll() {

 		List<Groups> instances = new ArrayList<Groups>();
		logger.debug("getting all Groups instances");
        instances = getSession().createCriteria(Groups.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Groups>) instances;
    }


	/**
	 * Gets a {@link List} of all Groups instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Groups> findByExample(Groups instance) {
        logger.debug("finding Groups instance by example");
        List<Groups> results = (List<Groups>) getSession()
                .createCriteria(Groups.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Groups instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Groups> findByFieldParcial(Groups.Fields field, String value) {
        logger.debug("finding Groups instance by parcial value: "+field+" like "+value);
        List<Groups> results = (List<Groups>) getSession()
                .createCriteria(Groups.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all Groups instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<Groups> findByName(String name) {
        Groups instance = new Groups();

        instance.setName(name);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Groups instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<Groups> findByDescription(String description) {
        Groups instance = new Groups();

        instance.setDescription(description);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Groups instances
	 * in the persistence layer than match the defaultGroup attribute with the given value
	 *
	 * @param defaultGroup to match
	 * @return the {@link List} of instances
	 */
    public List<Groups> findByDefaultGroup(boolean defaultGroup) {
        Groups instance = new Groups();

        instance.setDefaultGroup(defaultGroup);

        return findByExample(instance);
    }

}

