/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.logging;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.IAuditService;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLog;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLogDetail;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.hibernate.AuditDetail;
import pt.digitalis.dif.model.hibernate.IAuditingLogger;
import pt.digitalis.utils.common.StringUtils;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 24/11/2015
 */
public class AuditingLoggerDBImplementation implements IAuditingLogger {

    /**  */
    static private List<String> tablesNotToLOG = new ArrayList<String>();

    static
    {
        // Auditing tables are always excluded from auditing
        tablesNotToLOG.add(AuditLog.class.getSimpleName());
        tablesNotToLOG.add(AuditLogDetail.class.getSimpleName());
    }

    /**
     * @see pt.digitalis.dif.model.hibernate.IAuditingLogger#logDelete(java.lang.String, java.lang.String,
     *      java.util.List, java.lang.String, java.lang.String)
     */
    public void logDelete(String entityName, String entityID, List<AuditDetail> details, String userName, String appName)
            throws Exception
    {
        logEntry('D', entityName, entityID, details, userName, appName);
    }

    /**
     * Logs an DB action to the audit tables
     * 
     * @param operation
     * @param entityName
     * @param entityID
     * @param details
     * @param userName
     * @param appName
     * @throws DataSetException
     */
    protected void logEntry(Character operation, String entityName, String entityID, List<AuditDetail> details,
            String userName, String appName) throws DataSetException
    {
        if (!tablesNotToLOG.contains(entityName))
        {
            userName = StringUtils.nvl(userName, "No user logged");
            appName = StringUtils.nvl(appName, "Undetermined");

            // Trace info
            DIFLogger.getLogger().trace(
                    "Delete record of " + entityName + " issued by: " + userName + " (using \"" + appName + "\")");

            IAuditService auditDB = DIFIoCRegistry.getRegistry().getImplementation(IAuditService.class);

            // Log to database
            AuditLog log = new AuditLog();
            log.setApp(appName);
            log.setEntityName(entityName);
            log.setInstanceId(entityID);
            log.setOperation(operation);
            log.setOperationDate(new Timestamp(new Date().getTime()));
            log.setUserid(userName);
            log = auditDB.getAuditLogDataSet().insert(log);

            for (AuditDetail detail: details)
            {
                AuditLogDetail logdetail = new AuditLogDetail();
                logdetail.setAuditLog(log);
                logdetail.setColumnName(detail.getFieldName());
                logdetail.setPreviousValue(detail.getPreviousValue());
                logdetail.setNewValue(detail.getNewValue());
                auditDB.getAuditLogDetailDataSet().insert(logdetail);
            }
        }
    }

    /**
     * @see pt.digitalis.dif.model.hibernate.IAuditingLogger#logInsert(java.lang.String, java.lang.String,
     *      java.util.List, java.lang.String, java.lang.String)
     */
    public void logInsert(String entityName, String entityID, List<AuditDetail> details, String userName, String appName)
            throws Exception
    {
        logEntry('C', entityName, entityID, details, userName, appName);
    }

    /**
     * @see pt.digitalis.dif.model.hibernate.IAuditingLogger#logUpdate(java.lang.String, java.lang.String,
     *      java.util.List, java.lang.String, java.lang.String)
     */
    public void logUpdate(String entityName, String entityID, List<AuditDetail> details, String userName, String appName)
            throws Exception
    {
        logEntry('U', entityName, entityID, details, userName, appName);
    }
}
