package pt.digitalis.dif.dem.managers.impl.model.dao;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoAclDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Acl;
import pt.digitalis.dif.model.dataset.DataSetException;

/**
 * Home object for domain model class Acl. Generated on May 10, 2012 DIF build process for the Model layer
 * 
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAclDAO extends IAutoAclDAO {

    /**
     * Deletes a given group access to all entities.
     * 
     * @param groupID
     *            the group ID
     * @return T if the operation succeeded, F otherwise
     */
    public boolean deleteAllGroupAccess(String groupID);

    /**
     * Deletes a given user access to all entities.
     * 
     * @param userID
     *            the user ID
     * @return T if the operation succeeded, F otherwise
     */
    public boolean deleteAllUserAccess(String userID);

    /**
     * Deletes a given group access to a given entity.
     * 
     * @param groupID
     *            the group ID
     * @param entityType
     *            the entity type
     * @param entityID
     *            the entity ID
     * @return T if the operation succeeded, F otherwise
     * @throws DataSetException
     */
    public boolean deleteGroupAccess(String groupID, String entityType, String entityID) throws DataSetException;

    /**
     * Deletes public access to a given entity.
     * 
     * @param entityType
     *            the entity type
     * @param entityID
     *            the entity ID
     * @return T if the operation succeeded, F otherwise
     */
    public boolean deletePublicAccess(String entityType, String entityID);

    /**
     * Deletes a given user access to a given entity.
     * 
     * @param userID
     *            the user ID
     * @param entityType
     *            the entity type
     * @param entityID
     *            the entity ID
     * @return T if the operation succeeded, F otherwise
     * @throws DataSetException
     *             if {@link DataSetException} occurrs
     */
    public boolean deleteUserAccess(String userID, String entityType, String entityID) throws DataSetException;

    /**
     * Get a list of {@link Acl}
     * 
     * @param acl
     *            the {@link Acl}
     * @return List of {@link Acl}
     * @throws DataSetException
     *             if a {@link DataSetException} occurrs
     */
    public List<Acl> getAcl(Acl acl) throws DataSetException;

    /**
     * Get User Acl By group
     * 
     * @param groupId
     *            the groupId
     * @param entityType
     *            the Entity Type
     * @param entityID
     *            the Entity ID
     * @return {@link Acl}
     * @throws DataSetException
     *             if a dataset error occurrs
     */
    public Acl getAclByGroup(String groupId, String entityType, String entityID) throws DataSetException;

    /**
     * Get a Acl by public
     * 
     * @param entityType
     *            the entity type
     * @param entityID
     *            the entity Id
     * @return {@link Acl}
     * @throws DataSetException
     *             if dataset error occurrs
     */
    public Acl getAclByPublic(String entityType, String entityID) throws DataSetException;

    /**
     * Get User Acl By user
     * 
     * @param userId
     *            the userId
     * @param entityType
     *            the Entity Type
     * @param entityID
     *            the Entity ID
     * @return {@link Acl}
     * @throws DataSetException
     *             if a dataset error occurrs
     */
    public Acl getAclByUser(String userId, String entityType, String entityID) throws DataSetException;

}