package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLogDetail;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoAuditLogDetailDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class AuditLogDetail.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.AuditLogDetail
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoAuditLogDetailDAOImpl implements IAutoAuditLogDetailDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the AuditLogDetail entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<AuditLogDetail> getAuditLogDetailDataSet()
    {
        return new HibernateDataSet<AuditLogDetail>(AuditLogDetail.class, this, AuditLogDetail.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoAuditLogDetailDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a AuditLogDetail object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(AuditLogDetail transientInstance) {
        logger.debug("persisting AuditLogDetail instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified AuditLogDetail in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(AuditLogDetail instance) {
        logger.debug("attaching dirty AuditLogDetail instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified AuditLogDetail instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(AuditLogDetail instance) {
        logger.debug("attaching clean AuditLogDetail instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a AuditLogDetail instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(AuditLogDetail persistentInstance) {
        logger.debug("deleting AuditLogDetail instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a AuditLogDetail instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public AuditLogDetail merge(AuditLogDetail detachedInstance) {
        logger.debug("merging AuditLogDetail instance");
        AuditLogDetail result = (AuditLogDetail) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a AuditLogDetail instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public AuditLogDetail findById( java.lang.Long id) {
        logger.debug("getting AuditLogDetail instance with id: " + id);
        AuditLogDetail instance = (AuditLogDetail) getSession()
                .get(AuditLogDetail.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all AuditLogDetail instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<AuditLogDetail> findAll() {

 		List<AuditLogDetail> instances = new ArrayList<AuditLogDetail>();
		logger.debug("getting all AuditLogDetail instances");
        instances = getSession().createCriteria(AuditLogDetail.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<AuditLogDetail>) instances;
    }


	/**
	 * Gets a {@link List} of all AuditLogDetail instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<AuditLogDetail> findByExample(AuditLogDetail instance) {
        logger.debug("finding AuditLogDetail instance by example");
        List<AuditLogDetail> results = (List<AuditLogDetail>) getSession()
                .createCriteria(AuditLogDetail.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all AuditLogDetail instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<AuditLogDetail> findByFieldParcial(AuditLogDetail.Fields field, String value) {
        logger.debug("finding AuditLogDetail instance by parcial value: "+field+" like "+value);
        List<AuditLogDetail> results = (List<AuditLogDetail>) getSession()
                .createCriteria(AuditLogDetail.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all AuditLogDetail instances
	 * in the persistence layer than match the columnName attribute with the given value
	 *
	 * @param columnName to match
	 * @return the {@link List} of instances
	 */
    public List<AuditLogDetail> findByColumnName(String columnName) {
        AuditLogDetail instance = new AuditLogDetail();

        instance.setColumnName(columnName);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all AuditLogDetail instances
	 * in the persistence layer than match the previousValue attribute with the given value
	 *
	 * @param previousValue to match
	 * @return the {@link List} of instances
	 */
    public List<AuditLogDetail> findByPreviousValue(String previousValue) {
        AuditLogDetail instance = new AuditLogDetail();

        instance.setPreviousValue(previousValue);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all AuditLogDetail instances
	 * in the persistence layer than match the newValue attribute with the given value
	 *
	 * @param newValue to match
	 * @return the {@link List} of instances
	 */
    public List<AuditLogDetail> findByNewValue(String newValue) {
        AuditLogDetail instance = new AuditLogDetail();

        instance.setNewValue(newValue);

        return findByExample(instance);
    }

}

