package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IAuditService;
import pt.digitalis.dif.dem.managers.impl.model.dao.IAuditLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.AuditLogDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLog;
import pt.digitalis.dif.dem.managers.impl.model.dao.IAuditLogDetailDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.AuditLogDetailDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLogDetail;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class AuditServiceImpl implements IAuditService {

	/**
	 * Obtains a new AuditLog DAO
	 *
	 * @return A new IAuditLogDAO
	 */
    public IAuditLogDAO getAuditLogDAO() {
    	return new AuditLogDAOImpl();
    }

    /**
     * Obtains a new DataSet for the AuditLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<AuditLog> getAuditLogDataSet() {
        return new HibernateDataSet<AuditLog>(AuditLog.class, new AuditLogDAOImpl(),
                AuditLog.getPKFieldListAsString());
    }

	/**
	 * Obtains a new AuditLogDetail DAO
	 *
	 * @return A new IAuditLogDetailDAO
	 */
    public IAuditLogDetailDAO getAuditLogDetailDAO() {
    	return new AuditLogDetailDAOImpl();
    }

    /**
     * Obtains a new DataSet for the AuditLogDetail entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<AuditLogDetail> getAuditLogDetailDataSet() {
        return new HibernateDataSet<AuditLogDetail>(AuditLogDetail.class, new AuditLogDetailDAOImpl(),
                AuditLogDetail.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == AuditLog.class)
            return getAuditLogDataSet();

        if (clazz == AuditLogDetail.class)
            return getAuditLogDetailDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(AuditLog.class.getSimpleName()))
            return getAuditLogDataSet();

        if (entityName.equalsIgnoreCase(AuditLogDetail.class.getSimpleName()))
            return getAuditLogDetailDataSet();

        return null;
    }
}