DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'PERSISTENT_FORM';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
	    'CREATE TABLE DIF.PERSISTENT_FORM ( ' ||
		'  ID              NUMBER(10) NOT NULL, ' ||
		'  FORM_ID         VARCHAR2(500) NOT NULL, ' ||
		'  DISABLED_FIELDS VARCHAR2(4000), ' ||
		'  FIELD_DEFS      CLOB ' ||
		')';
	EXECUTE IMMEDIATE 'comment on column DIF.PERSISTENT_FORM.id is ''Unique identifier for PK''';
    EXECUTE IMMEDIATE 'comment on column DIF.PERSISTENT_FORM.form_id is ''Form unique identifier (stageID:formName[:businessID])''';
    EXECUTE IMMEDIATE 'comment on column DIF.PERSISTENT_FORM.disabled_fields is ''List of form fields disabled (comma separated)''';
    EXECUTE IMMEDIATE 'comment on column DIF.PERSISTENT_FORM.field_defs is ''List of form fields with their custom definitions ({fieldID1:{mandatory:ON/OFF,messages{language:en{label:A,hint:B,help:C}}})''';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'PERSISTENT_FORM'
  AND    CONSTRAINT_NAME = 'PERSISTENT_FORM_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.PERSISTENT_FORM ADD CONSTRAINT PERSISTENT_FORM_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_PERSISTENT_FORM';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_PERSISTENT_FORM MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/
