package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentForm;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoPersistentFormDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class PersistentForm.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.PersistentForm
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoPersistentFormDAOImpl implements IAutoPersistentFormDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the PersistentForm entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<PersistentForm> getPersistentFormDataSet()
    {
        return new HibernateDataSet<PersistentForm>(PersistentForm.class, this, PersistentForm.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoPersistentFormDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a PersistentForm object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(PersistentForm transientInstance) {
        logger.debug("persisting PersistentForm instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified PersistentForm in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(PersistentForm instance) {
        logger.debug("attaching dirty PersistentForm instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified PersistentForm instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(PersistentForm instance) {
        logger.debug("attaching clean PersistentForm instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a PersistentForm instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(PersistentForm persistentInstance) {
        logger.debug("deleting PersistentForm instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a PersistentForm instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public PersistentForm merge(PersistentForm detachedInstance) {
        logger.debug("merging PersistentForm instance");
        PersistentForm result = (PersistentForm) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a PersistentForm instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public PersistentForm findById( java.lang.Long id) {
        logger.debug("getting PersistentForm instance with id: " + id);
        PersistentForm instance = (PersistentForm) getSession()
                .get(PersistentForm.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<PersistentForm> findAll() {

 		List<PersistentForm> instances = new ArrayList<PersistentForm>();
		logger.debug("getting all PersistentForm instances");
        instances = getSession().createCriteria(PersistentForm.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<PersistentForm>) instances;
    }


	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<PersistentForm> findByExample(PersistentForm instance) {
        logger.debug("finding PersistentForm instance by example");
        List<PersistentForm> results = (List<PersistentForm>) getSession()
                .createCriteria(PersistentForm.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<PersistentForm> findByFieldParcial(PersistentForm.Fields field, String value) {
        logger.debug("finding PersistentForm instance by parcial value: "+field+" like "+value);
        List<PersistentForm> results = (List<PersistentForm>) getSession()
                .createCriteria(PersistentForm.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than match the formId attribute with the given value
	 *
	 * @param formId to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentForm> findByFormId(String formId) {
        PersistentForm instance = new PersistentForm();

        instance.setFormId(formId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than match the disabledFields attribute with the given value
	 *
	 * @param disabledFields to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentForm> findByDisabledFields(String disabledFields) {
        PersistentForm instance = new PersistentForm();

        instance.setDisabledFields(disabledFields);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all PersistentForm instances
	 * in the persistence layer than match the fieldDefs attribute with the given value
	 *
	 * @param fieldDefs to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentForm> findByFieldDefs(String fieldDefs) {
        PersistentForm instance = new PersistentForm();

        instance.setFieldDefs(fieldDefs);

        return findByExample(instance);
    }

}

