package pt.digitalis.dif.dem.managers.impl.model.dao.auto;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;

/**
 * Home object for domain model class CustomMessages. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoCustomMessagesDAO extends IHibernateDAO<CustomMessages> {

    /**
     * Attach an unmodified CustomMessages instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(CustomMessages instance);

    /**
     * Updates a modified CustomMessages in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(CustomMessages instance);

    /**
     * Removes a CustomMessages instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(CustomMessages persistentInstance);

    /**
     * Gets a {@link List} of all CustomMessages instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    public List<CustomMessages> findAll();

    /**
     * Gets a {@link List} of all CustomMessages instances in the persistence layer than match the entityId attribute
     * with the given value
     *
     * @param entityId
     *            to match
     * @return the {@link List} of instances
     */
    public List<CustomMessages> findByEntityId(String entityId);

    /**
     * Gets a {@link List} of all CustomMessages instances in the persistence layer than partially match the given field
     * with the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    public List<CustomMessages> findByFieldParcial(CustomMessages.Fields field, String value);

    /**
     * Finds a CustomMessages instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public CustomMessages findById(java.lang.Long id);

    /**
     * Gets a {@link List} of all CustomMessages instances in the persistence layer than match the language attribute
     * with the given value
     *
     * @param language
     *            to match
     * @return the {@link List} of instances
     */
    public List<CustomMessages> findByLanguage(String language);

    /**
     * Gets a {@link List} of all CustomMessages instances in the persistence layer than match the message attribute
     * with the given value
     *
     * @param message
     *            to match
     * @return the {@link List} of instances
     */
    public List<CustomMessages> findByMessage(String message);

    /**
     * Gets a {@link List} of all CustomMessages instances in the persistence layer than match the messageId attribute
     * with the given value
     *
     * @param messageId
     *            to match
     * @return the {@link List} of instances
     */
    public List<CustomMessages> findByMessageId(String messageId);

    /**
     * Obtains a new DataSet for the CustomMessages entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<CustomMessages> getCustomMessagesDataSet();

    /**
     * Merge a CustomMessages instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public CustomMessages merge(CustomMessages detachedInstance);

    /**
     * Persist a CustomMessages object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(CustomMessages transientInstance);
}
