package pt.digitalis.dif.dem.managers.impl.model.dao.auto;

import java.sql.Blob;
import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;

/**
 * Home object for domain model class PersistentAction. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoPersistentActionDAO extends IHibernateDAO<PersistentAction> {

    /**
     * Attach an unmodified PersistentAction instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(PersistentAction instance);

    /**
     * Updates a modified PersistentAction in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(PersistentAction instance);

    /**
     * Removes a PersistentAction instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(PersistentAction persistentInstance);

    /**
     * Gets a {@link List} of all PersistentAction instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    public List<PersistentAction> findAll();

    /**
     * Gets a {@link List} of all PersistentAction instances in the persistence layer than match the actionId attribute
     * with the given value
     *
     * @param actionId
     *            to match
     * @return the {@link List} of instances
     */
    public List<PersistentAction> findByActionId(Long actionId);

    /**
     * Gets a {@link List} of all PersistentAction instances in the persistence layer than partially match the given
     * field with the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    public List<PersistentAction> findByFieldParcial(PersistentAction.Fields field, String value);

    /**
     * Finds a PersistentAction instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public PersistentAction findById(java.lang.Long id);

    /**
     * Gets a {@link List} of all PersistentAction instances in the persistence layer than match the objectAction
     * attribute with the given value
     *
     * @param objectAction
     *            to match
     * @return the {@link List} of instances
     */
    public List<PersistentAction> findByObjectAction(Blob objectAction);

    /**
     * Gets a {@link List} of all PersistentAction instances in the persistence layer than match the poolName attribute
     * with the given value
     *
     * @param poolName
     *            to match
     * @return the {@link List} of instances
     */
    public List<PersistentAction> findByPoolName(String poolName);

    /**
     * Obtains a new DataSet for the PersistentAction entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<PersistentAction> getPersistentActionDataSet();

    /**
     * Merge a PersistentAction instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public PersistentAction merge(PersistentAction detachedInstance);

    /**
     * Persist a PersistentAction object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(PersistentAction transientInstance);
}
