package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import static org.hibernate.criterion.Example.create;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoAclDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Acl;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/**
 * Home object for domain model class Acl. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Acl
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoAclDAOImpl implements IAutoAclDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Constructor
     */
    public AutoAclDAOImpl()
    {
        this.logger = DIFLogger.getLogger();
    }

    /**
     * Attach an unmodified Acl instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(Acl instance)
    {
        logger.debug("attaching clean Acl instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

    /**
     * Updates a modified Acl in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(Acl instance)
    {
        logger.debug("attaching dirty Acl instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

    /**
     * Removes a Acl instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(Acl persistentInstance)
    {
        logger.debug("deleting Acl instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<Acl> findAll()
    {

        List<Acl> instances = new ArrayList<Acl>();
        logger.debug("getting all Acl instances");
        instances = getSession().createCriteria(Acl.class).list();
        if (instances.size() > 0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Acl>) instances;
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the entityId attribute with the
     * given value
     *
     * @param entityId
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByEntityId(String entityId)
    {
        Acl instance = new Acl();

        instance.setEntityId(entityId);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the entityType attribute with the
     * given value
     *
     * @param entityType
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByEntityType(String entityType)
    {
        Acl instance = new Acl();

        instance.setEntityType(entityType);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the example of the given instance
     *
     * @param instance
     *            to use as an example to the search
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    protected List<Acl> findByExample(Acl instance)
    {
        logger.debug("finding Acl instance by example");
        List<Acl> results = (List<Acl>) getSession().createCriteria(Acl.class).add(create(instance)).list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than partially match the given field with the
     * given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<Acl> findByFieldParcial(Acl.Fields field, String value)
    {
        logger.debug("finding Acl instance by parcial value: " + field + " like " + value);
        List<Acl> results = (List<Acl>) getSession().createCriteria(Acl.class)
                .add(Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase()).list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the groupId attribute with the given
     * value
     *
     * @param groupId
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByGroupId(String groupId)
    {
        Acl instance = new Acl();

        instance.setGroupId(groupId);

        return findByExample(instance);
    }

    /**
     * Finds a Acl instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public Acl findById(java.lang.Long id)
    {
        logger.debug("getting Acl instance with id: " + id);
        Acl instance = (Acl) getSession().get(Acl.class, id);
        if (instance == null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the isDefault attribute with the
     * given value
     *
     * @param isDefault
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByIsDefault(String isDefault)
    {
        Acl instance = new Acl();

        instance.setIsDefault(isDefault);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the isEnabled attribute with the
     * given value
     *
     * @param isEnabled
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByIsEnabled(String isEnabled)
    {
        Acl instance = new Acl();

        instance.setIsEnabled(isEnabled);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the publicAccess attribute with the
     * given value
     *
     * @param publicAccess
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByPublicAccess(String publicAccess)
    {
        Acl instance = new Acl();

        instance.setPublicAccess(publicAccess);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all Acl instances in the persistence layer than match the userId attribute with the given
     * value
     *
     * @param userId
     *            to match
     * @return the {@link List} of instances
     */
    public List<Acl> findByUserId(String userId)
    {
        Acl instance = new Acl();

        instance.setUserId(userId);

        return findByExample(instance);
    }

    /**
     * Obtains a new DataSet for the Acl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Acl> getAclDataSet()
    {
        return new HibernateDataSet<Acl>(Acl.class, this, Acl.getPKFieldListAsString());
    }

    /**
     * Retrieves the injected {@link Session} object
     *
     * @return the session
     */
    public Session getSession()
    {
        return DIFRepositoryFactory.getSession();
    }

    /**
     * Merge a Acl instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public Acl merge(Acl detachedInstance)
    {
        logger.debug("merging Acl instance");
        Acl result = (Acl) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

    /**
     * Persist a Acl object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(Acl transientInstance)
    {
        logger.debug("persisting Acl instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

}
