package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import static org.hibernate.criterion.Example.create;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoAuditLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.AuditLog;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/**
 * Home object for domain model class AuditLog. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.AuditLog
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoAuditLogDAOImpl implements IAutoAuditLogDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Constructor
     */
    public AutoAuditLogDAOImpl()
    {
        this.logger = DIFLogger.getLogger();
    }

    /**
     * Attach an unmodified AuditLog instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(AuditLog instance)
    {
        logger.debug("attaching clean AuditLog instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

    /**
     * Updates a modified AuditLog in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(AuditLog instance)
    {
        logger.debug("attaching dirty AuditLog instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

    /**
     * Removes a AuditLog instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(AuditLog persistentInstance)
    {
        logger.debug("deleting AuditLog instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<AuditLog> findAll()
    {

        List<AuditLog> instances = new ArrayList<AuditLog>();
        logger.debug("getting all AuditLog instances");
        instances = getSession().createCriteria(AuditLog.class).list();
        if (instances.size() > 0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<AuditLog>) instances;
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than match the app attribute with the
     * given value
     *
     * @param app
     *            to match
     * @return the {@link List} of instances
     */
    public List<AuditLog> findByApp(String app)
    {
        AuditLog instance = new AuditLog();

        instance.setApp(app);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than match the entityName attribute with
     * the given value
     *
     * @param entityName
     *            to match
     * @return the {@link List} of instances
     */
    public List<AuditLog> findByEntityName(String entityName)
    {
        AuditLog instance = new AuditLog();

        instance.setEntityName(entityName);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than match the example of the given
     * instance
     *
     * @param instance
     *            to use as an example to the search
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    protected List<AuditLog> findByExample(AuditLog instance)
    {
        logger.debug("finding AuditLog instance by example");
        List<AuditLog> results = (List<AuditLog>) getSession().createCriteria(AuditLog.class).add(create(instance))
                .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than partially match the given field with
     * the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<AuditLog> findByFieldParcial(AuditLog.Fields field, String value)
    {
        logger.debug("finding AuditLog instance by parcial value: " + field + " like " + value);
        List<AuditLog> results = (List<AuditLog>) getSession().createCriteria(AuditLog.class)
                .add(Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase()).list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

    /**
     * Finds a AuditLog instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public AuditLog findById(java.lang.Long id)
    {
        logger.debug("getting AuditLog instance with id: " + id);
        AuditLog instance = (AuditLog) getSession().get(AuditLog.class, id);
        if (instance == null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than match the instanceId attribute with
     * the given value
     *
     * @param instanceId
     *            to match
     * @return the {@link List} of instances
     */
    public List<AuditLog> findByInstanceId(String instanceId)
    {
        AuditLog instance = new AuditLog();

        instance.setInstanceId(instanceId);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than match the operation attribute with
     * the given value
     *
     * @param operation
     *            to match
     * @return the {@link List} of instances
     */
    public List<AuditLog> findByOperation(Character operation)
    {
        AuditLog instance = new AuditLog();

        instance.setOperation(operation);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than match the operationDate attribute
     * with the given value
     *
     * @param operationDate
     *            to match
     * @return the {@link List} of instances
     */
    public List<AuditLog> findByOperationDate(Timestamp operationDate)
    {
        AuditLog instance = new AuditLog();

        instance.setOperationDate(operationDate);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than match the process attribute with the
     * given value
     *
     * @param process
     *            to match
     * @return the {@link List} of instances
     */
    public List<AuditLog> findByProcess(String process)
    {
        AuditLog instance = new AuditLog();

        instance.setProcess(process);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all AuditLog instances in the persistence layer than match the userid attribute with the
     * given value
     *
     * @param userid
     *            to match
     * @return the {@link List} of instances
     */
    public List<AuditLog> findByUserid(String userid)
    {
        AuditLog instance = new AuditLog();

        instance.setUserid(userid);

        return findByExample(instance);
    }

    /**
     * Obtains a new DataSet for the AuditLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<AuditLog> getAuditLogDataSet()
    {
        return new HibernateDataSet<AuditLog>(AuditLog.class, this, AuditLog.getPKFieldListAsString());
    }

    /**
     * Retrieves the injected {@link Session} object
     *
     * @return the session
     */
    public Session getSession()
    {
        return DIFRepositoryFactory.getSession();
    }

    /**
     * Merge a AuditLog instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public AuditLog merge(AuditLog detachedInstance)
    {
        logger.debug("merging AuditLog instance");
        AuditLog result = (AuditLog) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

    /**
     * Persist a AuditLog object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(AuditLog transientInstance)
    {
        logger.debug("persisting AuditLog instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

}
