package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import static org.hibernate.criterion.Example.create;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoEcommercePaymentsDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/**
 * Home object for domain model class EcommercePayments. Generated by ORM Generator DIF build process for the Model
 * layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoEcommercePaymentsDAOImpl implements IAutoEcommercePaymentsDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Constructor
     */
    public AutoEcommercePaymentsDAOImpl()
    {
        this.logger = DIFLogger.getLogger();
    }

    /**
     * Attach an unmodified EcommercePayments instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(EcommercePayments instance)
    {
        logger.debug("attaching clean EcommercePayments instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

    /**
     * Updates a modified EcommercePayments in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(EcommercePayments instance)
    {
        logger.debug("attaching dirty EcommercePayments instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

    /**
     * Removes a EcommercePayments instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(EcommercePayments persistentInstance)
    {
        logger.debug("deleting EcommercePayments instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<EcommercePayments> findAll()
    {

        List<EcommercePayments> instances = new ArrayList<EcommercePayments>();
        logger.debug("getting all EcommercePayments instances");
        instances = getSession().createCriteria(EcommercePayments.class).list();
        if (instances.size() > 0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<EcommercePayments>) instances;
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the authorizationId
     * attribute with the given value
     *
     * @param authorizationId
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByAuthorizationId(String authorizationId)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setAuthorizationId(authorizationId);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the businessContext
     * attribute with the given value
     *
     * @param businessContext
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByBusinessContext(String businessContext)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setBusinessContext(businessContext);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the businessId
     * attribute with the given value
     *
     * @param businessId
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByBusinessId(String businessId)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setBusinessId(businessId);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the configurationId
     * attribute with the given value
     *
     * @param configurationId
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByConfigurationId(String configurationId)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setConfigurationId(configurationId);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the creator attribute
     * with the given value
     *
     * @param creator
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByCreator(String creator)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setCreator(creator);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the dateCreation
     * attribute with the given value
     *
     * @param dateCreation
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByDateCreation(Timestamp dateCreation)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setDateCreation(dateCreation);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the dateProcessed
     * attribute with the given value
     *
     * @param dateProcessed
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByDateProcessed(Timestamp dateProcessed)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setDateProcessed(dateProcessed);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the dateReceived
     * attribute with the given value
     *
     * @param dateReceived
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByDateReceived(Timestamp dateReceived)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setDateReceived(dateReceived);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the ecommerceProcessor
     * attribute with the given value
     *
     * @param ecommerceProcessor
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByEcommerceProcessor(String ecommerceProcessor)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setEcommerceProcessor(ecommerceProcessor);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the example of the
     * given instance
     *
     * @param instance
     *            to use as an example to the search
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    protected List<EcommercePayments> findByExample(EcommercePayments instance)
    {
        logger.debug("finding EcommercePayments instance by example");
        List<EcommercePayments> results = (List<EcommercePayments>) getSession().createCriteria(EcommercePayments.class)
                .add(create(instance)).list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than partially match the given
     * field with the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<EcommercePayments> findByFieldParcial(EcommercePayments.Fields field, String value)
    {
        logger.debug("finding EcommercePayments instance by parcial value: " + field + " like " + value);
        List<EcommercePayments> results = (List<EcommercePayments>) getSession().createCriteria(EcommercePayments.class)
                .add(Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase()).list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

    /**
     * Finds a EcommercePayments instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public EcommercePayments findById(java.lang.Long id)
    {
        logger.debug("getting EcommercePayments instance with id: " + id);
        EcommercePayments instance = (EcommercePayments) getSession().get(EcommercePayments.class, id);
        if (instance == null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the paymentValue
     * attribute with the given value
     *
     * @param paymentValue
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByPaymentValue(BigDecimal paymentValue)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setPaymentValue(paymentValue);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the redirectUrl
     * attribute with the given value
     *
     * @param redirectUrl
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByRedirectUrl(String redirectUrl)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setRedirectUrl(redirectUrl);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the securityToken
     * attribute with the given value
     *
     * @param securityToken
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findBySecurityToken(String securityToken)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setSecurityToken(securityToken);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the sentOnReport
     * attribute with the given value
     *
     * @param sentOnReport
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findBySentOnReport(boolean sentOnReport)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setSentOnReport(sentOnReport);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the status attribute
     * with the given value
     *
     * @param status
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByStatus(String status)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setStatus(status);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the statusMessage
     * attribute with the given value
     *
     * @param statusMessage
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByStatusMessage(String statusMessage)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setStatusMessage(statusMessage);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the transactionDate
     * attribute with the given value
     *
     * @param transactionDate
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByTransactionDate(Timestamp transactionDate)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setTransactionDate(transactionDate);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all EcommercePayments instances in the persistence layer than match the transactionId
     * attribute with the given value
     *
     * @param transactionId
     *            to match
     * @return the {@link List} of instances
     */
    public List<EcommercePayments> findByTransactionId(String transactionId)
    {
        EcommercePayments instance = new EcommercePayments();

        instance.setTransactionId(transactionId);

        return findByExample(instance);
    }

    /**
     * Obtains a new DataSet for the EcommercePayments entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EcommercePayments> getEcommercePaymentsDataSet()
    {
        return new HibernateDataSet<EcommercePayments>(EcommercePayments.class, this,
                EcommercePayments.getPKFieldListAsString());
    }

    /**
     * Retrieves the injected {@link Session} object
     *
     * @return the session
     */
    public Session getSession()
    {
        return DIFRepositoryFactory.getSession();
    }

    /**
     * Merge a EcommercePayments instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public EcommercePayments merge(EcommercePayments detachedInstance)
    {
        logger.debug("merging EcommercePayments instance");
        EcommercePayments result = (EcommercePayments) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

    /**
     * Persist a EcommercePayments object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(EcommercePayments transientInstance)
    {
        logger.debug("persisting EcommercePayments instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

}
