package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import static org.hibernate.criterion.Example.create;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoUserAttributesDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.UserAttributes;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/**
 * Home object for domain model class UserAttributes. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.UserAttributes
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoUserAttributesDAOImpl implements IAutoUserAttributesDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Constructor
     */
    public AutoUserAttributesDAOImpl()
    {
        this.logger = DIFLogger.getLogger();
    }

    /**
     * Attach an unmodified UserAttributes instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(UserAttributes instance)
    {
        logger.debug("attaching clean UserAttributes instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

    /**
     * Updates a modified UserAttributes in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(UserAttributes instance)
    {
        logger.debug("attaching dirty UserAttributes instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

    /**
     * Removes a UserAttributes instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(UserAttributes persistentInstance)
    {
        logger.debug("deleting UserAttributes instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

    /**
     * Gets a {@link List} of all UserAttributes instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<UserAttributes> findAll()
    {

        List<UserAttributes> instances = new ArrayList<UserAttributes>();
        logger.debug("getting all UserAttributes instances");
        instances = getSession().createCriteria(UserAttributes.class).list();
        if (instances.size() > 0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<UserAttributes>) instances;
    }

    /**
     * Gets a {@link List} of all UserAttributes instances in the persistence layer than match the attributeKey
     * attribute with the given value
     *
     * @param attributeKey
     *            to match
     * @return the {@link List} of instances
     */
    public List<UserAttributes> findByAttributeKey(String attributeKey)
    {
        UserAttributes instance = new UserAttributes();

        instance.setAttributeKey(attributeKey);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all UserAttributes instances in the persistence layer than match the attributeValue
     * attribute with the given value
     *
     * @param attributeValue
     *            to match
     * @return the {@link List} of instances
     */
    public List<UserAttributes> findByAttributeValue(String attributeValue)
    {
        UserAttributes instance = new UserAttributes();

        instance.setAttributeValue(attributeValue);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all UserAttributes instances in the persistence layer than match the example of the given
     * instance
     *
     * @param instance
     *            to use as an example to the search
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    protected List<UserAttributes> findByExample(UserAttributes instance)
    {
        logger.debug("finding UserAttributes instance by example");
        List<UserAttributes> results = (List<UserAttributes>) getSession().createCriteria(UserAttributes.class)
                .add(create(instance)).list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all UserAttributes instances in the persistence layer than partially match the given field
     * with the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<UserAttributes> findByFieldParcial(UserAttributes.Fields field, String value)
    {
        logger.debug("finding UserAttributes instance by parcial value: " + field + " like " + value);
        List<UserAttributes> results = (List<UserAttributes>) getSession().createCriteria(UserAttributes.class)
                .add(Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase()).list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

    /**
     * Finds a UserAttributes instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public UserAttributes findById(java.lang.Long id)
    {
        logger.debug("getting UserAttributes instance with id: " + id);
        UserAttributes instance = (UserAttributes) getSession().get(UserAttributes.class, id);
        if (instance == null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }

    /**
     * Retrieves the injected {@link Session} object
     *
     * @return the session
     */
    public Session getSession()
    {
        return DIFRepositoryFactory.getSession();
    }

    /**
     * Obtains a new DataSet for the UserAttributes entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserAttributes> getUserAttributesDataSet()
    {
        return new HibernateDataSet<UserAttributes>(UserAttributes.class, this,
                UserAttributes.getPKFieldListAsString());
    }

    /**
     * Merge a UserAttributes instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public UserAttributes merge(UserAttributes detachedInstance)
    {
        logger.debug("merging UserAttributes instance");
        UserAttributes result = (UserAttributes) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

    /**
     * Persist a UserAttributes object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(UserAttributes transientInstance)
    {
        logger.debug("persisting UserAttributes instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

}
