package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import static org.hibernate.criterion.Example.create;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoUserGroupsDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.UserGroups;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/**
 * Home object for domain model class UserGroups. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.UserGroups
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoUserGroupsDAOImpl implements IAutoUserGroupsDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Constructor
     */
    public AutoUserGroupsDAOImpl()
    {
        this.logger = DIFLogger.getLogger();
    }

    /**
     * Attach an unmodified UserGroups instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(UserGroups instance)
    {
        logger.debug("attaching clean UserGroups instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

    /**
     * Updates a modified UserGroups in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(UserGroups instance)
    {
        logger.debug("attaching dirty UserGroups instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

    /**
     * Removes a UserGroups instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(UserGroups persistentInstance)
    {
        logger.debug("deleting UserGroups instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

    /**
     * Gets a {@link List} of all UserGroups instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<UserGroups> findAll()
    {

        List<UserGroups> instances = new ArrayList<UserGroups>();
        logger.debug("getting all UserGroups instances");
        instances = getSession().createCriteria(UserGroups.class).list();
        if (instances.size() > 0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<UserGroups>) instances;
    }

    /**
     * Gets a {@link List} of all UserGroups instances in the persistence layer than match the example of the given
     * instance
     *
     * @param instance
     *            to use as an example to the search
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    protected List<UserGroups> findByExample(UserGroups instance)
    {
        logger.debug("finding UserGroups instance by example");
        List<UserGroups> results = (List<UserGroups>) getSession().createCriteria(UserGroups.class)
                .add(create(instance)).list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all UserGroups instances in the persistence layer than partially match the given field
     * with the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<UserGroups> findByFieldParcial(UserGroups.Fields field, String value)
    {
        logger.debug("finding UserGroups instance by parcial value: " + field + " like " + value);
        List<UserGroups> results = (List<UserGroups>) getSession().createCriteria(UserGroups.class)
                .add(Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase()).list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

    /**
     * Finds a UserGroups instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public UserGroups findById(java.lang.Long id)
    {
        logger.debug("getting UserGroups instance with id: " + id);
        UserGroups instance = (UserGroups) getSession().get(UserGroups.class, id);
        if (instance == null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }

    /**
     * Retrieves the injected {@link Session} object
     *
     * @return the session
     */
    public Session getSession()
    {
        return DIFRepositoryFactory.getSession();
    }

    /**
     * Obtains a new DataSet for the UserGroups entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserGroups> getUserGroupsDataSet()
    {
        return new HibernateDataSet<UserGroups>(UserGroups.class, this, UserGroups.getPKFieldListAsString());
    }

    /**
     * Merge a UserGroups instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public UserGroups merge(UserGroups detachedInstance)
    {
        logger.debug("merging UserGroups instance");
        UserGroups result = (UserGroups) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

    /**
     * Persist a UserGroups object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(UserGroups transientInstance)
    {
        logger.debug("persisting UserGroups instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

}
