package pt.digitalis.dif.dem.managers.impl.model.data;

import java.util.ArrayList;
import java.util.List;

import pt.digitalis.dif.model.utils.AbstractBeanAttributes;

/**
 * PersistentForm Generated on ORM Generator DIF build process for the Model layer
 */
@SuppressWarnings("serial")
public class PersistentForm extends AbstractBeanAttributes implements java.io.Serializable {

    /** PersistentForm attributes enumeration */
    public static class Fields {

        /** disabledFields column */
        public static final String DISABLEDFIELDS = "disabledFields";
        /** fieldDefs column */
        public static final String FIELDDEFS = "fieldDefs";
        /** formId column */
        public static final String FORMID = "formId";
        /** id column */
        public static final String ID = "id";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("formId");
            list.add("disabledFields");
            list.add("fieldDefs");

            return list;
        }
    }

    /** PersistentForm FK class */
    public static class FK {
    }

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    public synchronized static List<String> getPKFieldList()
    {
        if (pkFieldList == null)
        {
            pkFieldList = new ArrayList<String>();
            pkFieldList.add("id");
        }

        return pkFieldList;
    }

    // Fields

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
    public static String getPKFieldListAsString()
    {
        StringBuffer buffer = new StringBuffer();

        for (int i = 0; i < getPKFieldList().size(); i++)
        {
            if (i != 0)
                buffer.append(",");

            buffer.append(getPKFieldList().get(i));
        }

        return buffer.toString();
    }

    /** disabledFields private attribute */
    private String disabledFields;

    /** fieldDefs private attribute */
    private String fieldDefs;

    /** formId private attribute */
    private String formId;

    /** id private attribute */
    private Long id;

    /**
     * default constructor
     */
    public PersistentForm()
    {}

    /**
     * minimal constructor
     *
     * @param formId
     *            }
     */
    public PersistentForm(String formId)
    {
        this.formId = formId;
    }

    /**
     * full constructor
     *
     * @param formId
     * @param disabledFields
     * @param fieldDefs
     */
    public PersistentForm(String formId, String disabledFields, String fieldDefs)
    {
        this.formId = formId;
        this.disabledFields = disabledFields;
        this.fieldDefs = fieldDefs;
    }

    // Constructors

    /**
     * Compares the String representation of the PersistentForm object
     *
     * @param other
     *            The object to compare to
     * @return true of the objects are equal
     */
    public boolean equals(PersistentForm other)
    {
        return this.toString().equals(other.toString());
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
    @Override
    public String getAttributeAsString(String attributeName)
    {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else
        {
            return value.toString().trim();
        }
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    protected Object getAttributeNoGraphNavigation(String attributeName)
    {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("formId".equalsIgnoreCase(attributeName))
            return formId;
        if ("disabledFields".equalsIgnoreCase(attributeName))
            return disabledFields;
        if ("fieldDefs".equalsIgnoreCase(attributeName))
            return fieldDefs;

        return null;
    }

    // Property accessors

    /**
     * disabledFields getter method
     *
     * @return disabledFields method
     */
    public String getDisabledFields()
    {
        return this.disabledFields;
    }

    /**
     * fieldDefs getter method
     *
     * @return fieldDefs method
     */
    public String getFieldDefs()
    {
        return this.fieldDefs;
    }

    /**
     * formId getter method
     *
     * @return formId method
     */
    public String getFormId()
    {
        return this.formId;
    }

    /**
     * id getter method
     *
     * @return id method
     */
    public Long getId()
    {
        return this.id;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue)
    {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long) attributeValue;
        if ("formId".equalsIgnoreCase(attributeName))
            formId = (String) attributeValue;
        if ("disabledFields".equalsIgnoreCase(attributeName))
            disabledFields = (String) attributeValue;
        if ("fieldDefs".equalsIgnoreCase(attributeName))
            fieldDefs = (String) attributeValue;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue)
    {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("formId".equalsIgnoreCase(attributeName))
            this.formId = attributeValue;

        if ("disabledFields".equalsIgnoreCase(attributeName))
            this.disabledFields = attributeValue;

        if ("fieldDefs".equalsIgnoreCase(attributeName))
            this.fieldDefs = attributeValue;

    }

    /**
     * disabledFields setter method
     *
     * @param disabledFields
     * @return PersistentForm modified instance
     */
    public PersistentForm setDisabledFields(String disabledFields)
    {
        this.disabledFields = disabledFields;

        return this;
    }

    /**
     * fieldDefs setter method
     *
     * @param fieldDefs
     * @return PersistentForm modified instance
     */
    public PersistentForm setFieldDefs(String fieldDefs)
    {
        this.fieldDefs = fieldDefs;

        return this;
    }

    /**
     * formId setter method
     *
     * @param formId
     * @return PersistentForm modified instance
     */
    public PersistentForm setFormId(String formId)
    {
        this.formId = formId;

        return this;
    }

    /**
     * id setter method
     *
     * @param id
     * @return PersistentForm modified instance
     */
    public PersistentForm setId(Long id)
    {
        this.id = id;

        return this;
    }

    /**
     * Creates a String representation of the PersistentForm object
     *
     * @return the compiled String
     */
    public String toString()
    {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");
        buffer.append("formId").append("='").append(getFormId()).append("' ");
        buffer.append("disabledFields").append("='").append(getDisabledFields()).append("' ");
        buffer.append("fieldDefs").append("='").append(getFieldDefs()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

}
