package pt.digitalis.dif.dem.managers.impl.model.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import pt.digitalis.dif.model.utils.AbstractBeanAttributes;

/**
 * Users Generated on ORM Generator DIF build process for the Model layer
 */
@SuppressWarnings("serial")
public class Users extends AbstractBeanAttributes implements java.io.Serializable {

    /** Users attributes enumeration */
    public static class Fields {

        /** defaultUser column */
        public static final String DEFAULTUSER = "defaultUser";
        /** email column */
        public static final String EMAIL = "email";
        /** enabled column */
        public static final String ENABLED = "enabled";
        /** id column */
        public static final String ID = "id";
        /** name column */
        public static final String NAME = "name";
        /** nick column */
        public static final String NICK = "nick";
        /** password column */
        public static final String PASSWORD = "password";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("email");
            list.add("enabled");
            list.add("name");
            list.add("password");
            list.add("defaultUser");
            list.add("nick");

            return list;
        }
    }

    /** Users FK class */
    public static class FK {

        /** groups relation */
        public static final String GROUPS = "groups";
        /** userAttributeses relation */
        public static final String USERATTRIBUTESES = "userAttributeses";
        /** userGroupses relation */
        public static final String USERGROUPSES = "userGroupses";
    }

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    public synchronized static List<String> getPKFieldList()
    {
        if (pkFieldList == null)
        {
            pkFieldList = new ArrayList<String>();
            pkFieldList.add("id");
        }

        return pkFieldList;
    }

    // Fields

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
    public static String getPKFieldListAsString()
    {
        StringBuffer buffer = new StringBuffer();

        for (int i = 0; i < getPKFieldList().size(); i++)
        {
            if (i != 0)
                buffer.append(",");

            buffer.append(getPKFieldList().get(i));
        }

        return buffer.toString();
    }

    /** defaultUser private attribute */
    private boolean defaultUser;

    /** email private attribute */
    private String email;

    /** enabled private attribute */
    private boolean enabled;

    /** groups private attribute */
    private Groups groups;

    /** id private attribute */
    private String id;

    /** name private attribute */
    private String name;

    /** nick private attribute */
    private String nick;

    /** password private attribute */
    private String password;

    /** userAttributeses private attribute */
    private Set<UserAttributes> userAttributeses = new HashSet<UserAttributes>(0);

    /** userGroupses private attribute */
    private Set<UserGroups> userGroupses = new HashSet<UserGroups>(0);

    /**
     * default constructor
     */
    public Users()
    {}

    /**
     * minimal constructor
     *
     * @param id
     * @param enabled
     * @param password
     * @param defaultUser
     *            }
     */
    public Users(String id, boolean enabled, String password, boolean defaultUser)
    {
        this.id = id;
        this.enabled = enabled;
        this.password = password;
        this.defaultUser = defaultUser;
    }

    /**
     * full constructor
     *
     * @param id
     * @param groups
     * @param email
     * @param enabled
     * @param name
     * @param password
     * @param defaultUser
     * @param nick
     * @param userAttributeses
     * @param userGroupses
     */
    public Users(String id, Groups groups, String email, boolean enabled, String name, String password,
            boolean defaultUser, String nick, Set<UserAttributes> userAttributeses, Set<UserGroups> userGroupses)
    {
        this.id = id;
        this.groups = groups;
        this.email = email;
        this.enabled = enabled;
        this.name = name;
        this.password = password;
        this.defaultUser = defaultUser;
        this.nick = nick;
        this.userAttributeses = userAttributeses;
        this.userGroupses = userGroupses;
    }

    // Constructors

    /**
     * Compares the String representation of the Users object
     *
     * @param other
     *            The object to compare to
     * @return true of the objects are equal
     */
    public boolean equals(Users other)
    {
        return this.toString().equals(other.toString());
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
    @Override
    public String getAttributeAsString(String attributeName)
    {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else
        {
            return value.toString().trim();
        }
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    protected Object getAttributeNoGraphNavigation(String attributeName)
    {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("groups".equalsIgnoreCase(attributeName))
            return groups;
        if ("email".equalsIgnoreCase(attributeName))
            return email;
        if ("enabled".equalsIgnoreCase(attributeName))
            return enabled;
        if ("name".equalsIgnoreCase(attributeName))
            return name;
        if ("password".equalsIgnoreCase(attributeName))
            return password;
        if ("defaultUser".equalsIgnoreCase(attributeName))
            return defaultUser;
        if ("nick".equalsIgnoreCase(attributeName))
            return nick;
        if ("userAttributeses".equalsIgnoreCase(attributeName))
            return userAttributeses;
        if ("userGroupses".equalsIgnoreCase(attributeName))
            return userGroupses;

        return null;
    }

    // Property accessors

    /**
     * email getter method
     *
     * @return email method
     */
    public String getEmail()
    {
        return this.email;
    }

    /**
     * groups getter method
     *
     * @return groups method
     */
    public Groups getGroups()
    {
        return this.groups;
    }

    /**
     * id getter method
     *
     * @return id method
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * name getter method
     *
     * @return name method
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * nick getter method
     *
     * @return nick method
     */
    public String getNick()
    {
        return this.nick;
    }

    /**
     * password getter method
     *
     * @return password method
     */
    public String getPassword()
    {
        return this.password;
    }

    /**
     * userAttributeses getter method
     *
     * @return userAttributeses method
     */
    public Set<UserAttributes> getUserAttributeses()
    {
        return this.userAttributeses;
    }

    /**
     * userGroupses getter method
     *
     * @return userGroupses method
     */
    public Set<UserGroups> getUserGroupses()
    {
        return this.userGroupses;
    }

    /**
     * defaultUser getter method
     *
     * @return defaultUser method
     */
    public boolean isDefaultUser()
    {
        return this.defaultUser;
    }

    /**
     * enabled getter method
     *
     * @return enabled method
     */
    public boolean isEnabled()
    {
        return this.enabled;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue)
    {

        if ("id".equalsIgnoreCase(attributeName))
            id = (String) attributeValue;
        if ("groups".equalsIgnoreCase(attributeName))
            groups = (Groups) attributeValue;
        if ("email".equalsIgnoreCase(attributeName))
            email = (String) attributeValue;
        if ("enabled".equalsIgnoreCase(attributeName))
            enabled = (Boolean) attributeValue;
        if ("name".equalsIgnoreCase(attributeName))
            name = (String) attributeValue;
        if ("password".equalsIgnoreCase(attributeName))
            password = (String) attributeValue;
        if ("defaultUser".equalsIgnoreCase(attributeName))
            defaultUser = (Boolean) attributeValue;
        if ("nick".equalsIgnoreCase(attributeName))
            nick = (String) attributeValue;
        if ("userAttributeses".equalsIgnoreCase(attributeName))
            userAttributeses = (Set<UserAttributes>) attributeValue;
        if ("userGroupses".equalsIgnoreCase(attributeName))
            userGroupses = (Set<UserGroups>) attributeValue;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue)
    {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = attributeValue;

        if ("email".equalsIgnoreCase(attributeName))
            this.email = attributeValue;

        if ("enabled".equalsIgnoreCase(attributeName))
            this.enabled = Boolean.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
            this.name = attributeValue;

        if ("password".equalsIgnoreCase(attributeName))
            this.password = attributeValue;

        if ("defaultUser".equalsIgnoreCase(attributeName))
            this.defaultUser = Boolean.valueOf(attributeValue);

        if ("nick".equalsIgnoreCase(attributeName))
            this.nick = attributeValue;

    }

    /**
     * defaultUser setter method
     *
     * @param defaultUser
     * @return Users modified instance
     */
    public Users setDefaultUser(boolean defaultUser)
    {
        this.defaultUser = defaultUser;

        return this;
    }

    /**
     * email setter method
     *
     * @param email
     * @return Users modified instance
     */
    public Users setEmail(String email)
    {
        this.email = email;

        return this;
    }

    /**
     * enabled setter method
     *
     * @param enabled
     * @return Users modified instance
     */
    public Users setEnabled(boolean enabled)
    {
        this.enabled = enabled;

        return this;
    }

    /**
     * groups setter method
     *
     * @param groups
     * @return Users modified instance
     */
    public Users setGroups(Groups groups)
    {
        this.groups = groups;

        return this;
    }

    /**
     * id setter method
     *
     * @param id
     * @return Users modified instance
     */
    public Users setId(String id)
    {
        this.id = id;

        return this;
    }

    /**
     * name setter method
     *
     * @param name
     * @return Users modified instance
     */
    public Users setName(String name)
    {
        this.name = name;

        return this;
    }

    /**
     * nick setter method
     *
     * @param nick
     * @return Users modified instance
     */
    public Users setNick(String nick)
    {
        this.nick = nick;

        return this;
    }

    /**
     * password setter method
     *
     * @param password
     * @return Users modified instance
     */
    public Users setPassword(String password)
    {
        this.password = password;

        return this;
    }

    /**
     * userAttributeses setter method
     *
     * @param userAttributeses
     * @return Users modified instance
     */
    public Users setUserAttributeses(Set<UserAttributes> userAttributeses)
    {
        this.userAttributeses = userAttributeses;

        return this;
    }

    /**
     * userGroupses setter method
     *
     * @param userGroupses
     * @return Users modified instance
     */
    public Users setUserGroupses(Set<UserGroups> userGroupses)
    {
        this.userGroupses = userGroupses;

        return this;
    }

    /**
     * Creates a String representation of the Users object
     *
     * @return the compiled String
     */
    public String toString()
    {
        StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");
        buffer.append("email").append("='").append(getEmail()).append("' ");
        buffer.append("enabled").append("='").append(isEnabled()).append("' ");
        buffer.append("name").append("='").append(getName()).append("' ");
        buffer.append("password").append("='").append(getPassword()).append("' ");
        buffer.append("defaultUser").append("='").append(isDefaultUser()).append("' ");
        buffer.append("nick").append("='").append(getNick()).append("' ");
        buffer.append("]");

        return buffer.toString();
    }

}
