package pt.digitalis.dif.ioc;

import pt.digitalis.dif.controller.interfaces.IModelManager;
import pt.digitalis.dif.dem.managers.ICustomFormManager;
import pt.digitalis.dif.dem.managers.impl.CustomFormManagerDBImpl;
import pt.digitalis.dif.dem.managers.impl.DIFRepositoryDBModelManager;
import pt.digitalis.dif.model.hibernate.IAuditingLogger;
import pt.digitalis.dif.utils.logging.AuditingLoggerDBImplementation;
import pt.digitalis.dif.utils.logging.ErrorLogManagerDBImpl;
import pt.digitalis.dif.utils.logging.IErrorLogManager;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Jan 3, 2014
 */
public class DIFRepositoryModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.bind(IModelManager.class, DIFRepositoryDBModelManager.class)
                .withId(DIFRepositoryDBModelManager.MODEL_ID);

        // Form customization
        binder.bind(ICustomFormManager.class, CustomFormManagerDBImpl.class).asSingleton().override();

        // Utilities
        binder.bind(IErrorLogManager.class, ErrorLogManagerDBImpl.class).asSingleton().override();
        binder.bind(IAuditingLogger.class, AuditingLoggerDBImplementation.class).asSingleton().override();
    }
}
