/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoCustomMessagesDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoCustomMessagesDAOImpl
implements IAutoCustomMessagesDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public void attachClean(CustomMessages instance) {
        this.logger.debug((Object)"attaching clean CustomMessages instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachDirty(CustomMessages instance) {
        this.logger.debug((Object)"attaching dirty CustomMessages instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(CustomMessages persistentInstance) {
        this.logger.debug((Object)"deleting CustomMessages instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public List<CustomMessages> findAll() {
        List<CustomMessages> instances = new ArrayList();
        this.logger.debug((Object)"getting all CustomMessages instances");
        instances = this.getSession().createCriteria(CustomMessages.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    @Override
    public List<CustomMessages> findByEntityId(String entityId) {
        CustomMessages instance = new CustomMessages();
        instance.setEntityId(entityId);
        return this.findByExample(instance);
    }

    protected List<CustomMessages> findByExample(CustomMessages instance) {
        this.logger.debug((Object)"finding CustomMessages instance by example");
        List results = this.getSession().createCriteria(CustomMessages.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<CustomMessages> findByFieldParcial(CustomMessages.Fields field, String value) {
        this.logger.debug((Object)("finding CustomMessages instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(CustomMessages.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public CustomMessages findById(Long id) {
        this.logger.debug((Object)("getting CustomMessages instance with id: " + id));
        CustomMessages instance = (CustomMessages)this.getSession().get(CustomMessages.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<CustomMessages> findByLanguage(String language) {
        CustomMessages instance = new CustomMessages();
        instance.setLanguage(language);
        return this.findByExample(instance);
    }

    @Override
    public List<CustomMessages> findByMessage(String message) {
        CustomMessages instance = new CustomMessages();
        instance.setMessage(message);
        return this.findByExample(instance);
    }

    @Override
    public List<CustomMessages> findByMessageId(String messageId) {
        CustomMessages instance = new CustomMessages();
        instance.setMessageId(messageId);
        return this.findByExample(instance);
    }

    @Override
    public IDataSet<CustomMessages> getCustomMessagesDataSet() {
        return new HibernateDataSet(CustomMessages.class, (IHibernateDAO)this, CustomMessages.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public CustomMessages merge(CustomMessages detachedInstance) {
        this.logger.debug((Object)"merging CustomMessages instance");
        CustomMessages result = (CustomMessages)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public void persist(CustomMessages transientInstance) {
        this.logger.debug((Object)"persisting CustomMessages instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }
}

