/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoEcommercePaymentsDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoEcommercePaymentsDAOImpl
implements IAutoEcommercePaymentsDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public void attachClean(EcommercePayments instance) {
        this.logger.debug((Object)"attaching clean EcommercePayments instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachDirty(EcommercePayments instance) {
        this.logger.debug((Object)"attaching dirty EcommercePayments instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(EcommercePayments persistentInstance) {
        this.logger.debug((Object)"deleting EcommercePayments instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public List<EcommercePayments> findAll() {
        List<EcommercePayments> instances = new ArrayList();
        this.logger.debug((Object)"getting all EcommercePayments instances");
        instances = this.getSession().createCriteria(EcommercePayments.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    @Override
    public List<EcommercePayments> findByAuthorizationId(String authorizationId) {
        EcommercePayments instance = new EcommercePayments();
        instance.setAuthorizationId(authorizationId);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByBusinessContext(String businessContext) {
        EcommercePayments instance = new EcommercePayments();
        instance.setBusinessContext(businessContext);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByBusinessId(String businessId) {
        EcommercePayments instance = new EcommercePayments();
        instance.setBusinessId(businessId);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByConfigurationId(String configurationId) {
        EcommercePayments instance = new EcommercePayments();
        instance.setConfigurationId(configurationId);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByCreator(String creator) {
        EcommercePayments instance = new EcommercePayments();
        instance.setCreator(creator);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByDateCreation(Timestamp dateCreation) {
        EcommercePayments instance = new EcommercePayments();
        instance.setDateCreation(dateCreation);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByDateProcessed(Timestamp dateProcessed) {
        EcommercePayments instance = new EcommercePayments();
        instance.setDateProcessed(dateProcessed);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByDateReceived(Timestamp dateReceived) {
        EcommercePayments instance = new EcommercePayments();
        instance.setDateReceived(dateReceived);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByEcommerceProcessor(String ecommerceProcessor) {
        EcommercePayments instance = new EcommercePayments();
        instance.setEcommerceProcessor(ecommerceProcessor);
        return this.findByExample(instance);
    }

    protected List<EcommercePayments> findByExample(EcommercePayments instance) {
        this.logger.debug((Object)"finding EcommercePayments instance by example");
        List results = this.getSession().createCriteria(EcommercePayments.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<EcommercePayments> findByFieldParcial(EcommercePayments.Fields field, String value) {
        this.logger.debug((Object)("finding EcommercePayments instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(EcommercePayments.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public EcommercePayments findById(Long id) {
        this.logger.debug((Object)("getting EcommercePayments instance with id: " + id));
        EcommercePayments instance = (EcommercePayments)this.getSession().get(EcommercePayments.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<EcommercePayments> findByPaymentValue(BigDecimal paymentValue) {
        EcommercePayments instance = new EcommercePayments();
        instance.setPaymentValue(paymentValue);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByRedirectUrl(String redirectUrl) {
        EcommercePayments instance = new EcommercePayments();
        instance.setRedirectUrl(redirectUrl);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findBySecurityToken(String securityToken) {
        EcommercePayments instance = new EcommercePayments();
        instance.setSecurityToken(securityToken);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findBySentOnReport(boolean sentOnReport) {
        EcommercePayments instance = new EcommercePayments();
        instance.setSentOnReport(sentOnReport);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByStatus(String status) {
        EcommercePayments instance = new EcommercePayments();
        instance.setStatus(status);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByStatusMessage(String statusMessage) {
        EcommercePayments instance = new EcommercePayments();
        instance.setStatusMessage(statusMessage);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByTransactionDate(Timestamp transactionDate) {
        EcommercePayments instance = new EcommercePayments();
        instance.setTransactionDate(transactionDate);
        return this.findByExample(instance);
    }

    @Override
    public List<EcommercePayments> findByTransactionId(String transactionId) {
        EcommercePayments instance = new EcommercePayments();
        instance.setTransactionId(transactionId);
        return this.findByExample(instance);
    }

    @Override
    public IDataSet<EcommercePayments> getEcommercePaymentsDataSet() {
        return new HibernateDataSet(EcommercePayments.class, (IHibernateDAO)this, EcommercePayments.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public EcommercePayments merge(EcommercePayments detachedInstance) {
        this.logger.debug((Object)"merging EcommercePayments instance");
        EcommercePayments result = (EcommercePayments)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public void persist(EcommercePayments transientInstance) {
        this.logger.debug((Object)"persisting EcommercePayments instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }
}

