/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoErrorLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ErrorLog;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoErrorLogDAOImpl
implements IAutoErrorLogDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public void attachClean(ErrorLog instance) {
        this.logger.debug((Object)"attaching clean ErrorLog instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachDirty(ErrorLog instance) {
        this.logger.debug((Object)"attaching dirty ErrorLog instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ErrorLog persistentInstance) {
        this.logger.debug((Object)"deleting ErrorLog instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public List<ErrorLog> findAll() {
        List<ErrorLog> instances = new ArrayList();
        this.logger.debug((Object)"getting all ErrorLog instances");
        instances = this.getSession().createCriteria(ErrorLog.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    @Override
    public List<ErrorLog> findByAppName(String appName) {
        ErrorLog instance = new ErrorLog();
        instance.setAppName(appName);
        return this.findByExample(instance);
    }

    @Override
    public List<ErrorLog> findByErroDate(Date erroDate) {
        ErrorLog instance = new ErrorLog();
        instance.setErroDate(erroDate);
        return this.findByExample(instance);
    }

    @Override
    public List<ErrorLog> findByErrorDescription(String errorDescription) {
        ErrorLog instance = new ErrorLog();
        instance.setErrorDescription(errorDescription);
        return this.findByExample(instance);
    }

    protected List<ErrorLog> findByExample(ErrorLog instance) {
        this.logger.debug((Object)"finding ErrorLog instance by example");
        List results = this.getSession().createCriteria(ErrorLog.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ErrorLog> findByFieldParcial(ErrorLog.Fields field, String value) {
        this.logger.debug((Object)("finding ErrorLog instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ErrorLog.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public ErrorLog findById(Long id) {
        this.logger.debug((Object)("getting ErrorLog instance with id: " + id));
        ErrorLog instance = (ErrorLog)this.getSession().get(ErrorLog.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ErrorLog> findByProcessName(String processName) {
        ErrorLog instance = new ErrorLog();
        instance.setProcessName(processName);
        return this.findByExample(instance);
    }

    @Override
    public IDataSet<ErrorLog> getErrorLogDataSet() {
        return new HibernateDataSet(ErrorLog.class, (IHibernateDAO)this, ErrorLog.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public ErrorLog merge(ErrorLog detachedInstance) {
        this.logger.debug((Object)"merging ErrorLog instance");
        ErrorLog result = (ErrorLog)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public void persist(ErrorLog transientInstance) {
        this.logger.debug((Object)"persisting ErrorLog instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }
}

