/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl;

import pt.digitalis.dif.dem.managers.impl.TemplateManagerStaticImpl;
import pt.digitalis.dif.dem.managers.impl.model.ITemplateRepositoryService;
import pt.digitalis.dif.dem.managers.impl.model.data.TemplateRepository;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.utils.common.IBeanAttributes;

public class TemplateManagerDBImpl
extends TemplateManagerStaticImpl {
    public boolean allowTemplateCustomization() {
        return true;
    }

    protected StringBuffer doGetTemplateContent(String resource, String language) throws Exception {
        StringBuffer result = null;
        ITemplateRepositoryService templateRepositoryService = (ITemplateRepositoryService)DIFIoCRegistry.getRegistry().getImplementation(ITemplateRepositoryService.class);
        Query query = templateRepositoryService.getTemplateRepositoryDataSet().query();
        query.equals("name", resource);
        query.equals("language", language);
        TemplateRepository template = (TemplateRepository)query.singleValue();
        result = template != null ? new StringBuffer(template.getContent()) : super.doGetTemplateContent(resource, language);
        return result;
    }

    public void saveTemplateContent(String resource, String language, String newContent) throws Exception {
        this.invalidateCache(resource);
        ITemplateRepositoryService templateRepositoryService = (ITemplateRepositoryService)DIFIoCRegistry.getRegistry().getImplementation(ITemplateRepositoryService.class);
        IDataSet<TemplateRepository> dataSet = templateRepositoryService.getTemplateRepositoryDataSet();
        Query query = dataSet.query();
        query.equals("name", resource);
        query.equals("language", language);
        TemplateRepository template = (TemplateRepository)query.singleValue();
        if (template != null) {
            template.setContent(newContent);
            template = (TemplateRepository)dataSet.update((IBeanAttributes)template);
        } else {
            template = new TemplateRepository();
            template.setName(resource);
            template.setLanguage(language);
            template.setContent(newContent);
            template = (TemplateRepository)dataSet.insert((IBeanAttributes)template);
        }
    }
}

