DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS
	WHERE TABLE_SCHEMA = 'DIF'
	AND TABLE_NAME = 'AUDIT_LOG'
	AND COLUMN_NAME = 'PROCESS';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`AUDIT_LOG` CHANGE COLUMN `app` `app` VARCHAR(30) NULL;
		ALTER TABLE `DIF`.`AUDIT_LOG` ADD COLUMN `PROCESS` VARCHAR(300) NULL COMMENT 'The process name';
		UPDATE `DIF`.`AUDIT_LOG` set `PROCESS` = `APP`, `APP` = null;
		ALTER TABLE `DIF`.`AUDIT_LOG` CHANGE COLUMN `PROCESS` `PROCESS` VARCHAR(300) NOT NULL;
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

DROP PROCEDURE IF EXISTS createIndex;
$$

CREATE PROCEDURE createIndex()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM INFORMATION_SCHEMA.STATISTICS
	WHERE TABLE_CATALOG = 'def'
	AND TABLE_SCHEMA = 'DIF'
	AND TABLE_NAME = 'AUDIT_LOG'
	AND INDEX_NAME = 'AUDIT_LOG_IDX';

	IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`AUDIT_LOG` ADD INDEX `AUDIT_LOG_IDX` (`PROCESS`, `ENTITY_NAME`, `OPERATION_DATE`);
    END IF;
END
$$

CALL createIndex();
$$

DROP PROCEDURE IF EXISTS createIndex;
$$

ALTER TABLE `DIF`.`AUDIT_LOG` CHANGE COLUMN `APP` `APP` VARCHAR(300);
$$

ALTER TABLE `DIF`.`AUDIT_LOG` CHANGE COLUMN `PROCESS` `PROCESS` VARCHAR(300);	
$$