DELIMITER $$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'REPORT_INSTANCE_AREA' 
	AND COLUMN_NAME = 'REPORT_TEMPLATE_AREA_ID'
	AND IS_NULLABLE = 'NO';
	
	IF TOTAL > 0 THEN
		ALTER TABLE `DIF`.`REPORT_INSTANCE_AREA` CHANGE COLUMN `REPORT_TEMPLATE_AREA_ID` `REPORT_TEMPLATE_AREA_ID` INT(10) COMMENT 'The parent template area ID';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$
