package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Dashboard;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Dashboard.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Dashboard
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoDashboardDAO extends IHibernateDAO<Dashboard> {

    /**
     * Obtains a new DataSet for the Dashboard entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Dashboard> getDashboardDataSet();

	/**
	 * Persist a Dashboard object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Dashboard transientInstance);

	/**
	 * Updates a modified Dashboard in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Dashboard instance);

	/**
	 * Attach an unmodified Dashboard instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Dashboard instance);

	/**
	 * Removes a Dashboard instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Dashboard persistentInstance);

	/**
	 * Merge a Dashboard instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Dashboard merge(Dashboard detachedInstance);

	/**
	 * Finds a Dashboard instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Dashboard findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Dashboard instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Dashboard> findAll();


	/**
	 * Gets a {@link List} of all Dashboard instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Dashboard> findByFieldParcial(Dashboard.Fields field, String value);

	/**
	 * Gets a {@link List} of all Dashboard instances
	 * in the persistence layer than match the uniqueId attribute with the given value
	 *
	 * @param uniqueId to match
	 * @return the {@link List} of instances
	 */
    public List<Dashboard> findByUniqueId(String uniqueId);

	/**
	 * Gets a {@link List} of all Dashboard instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<Dashboard> findByTitle(String title);

	/**
	 * Gets a {@link List} of all Dashboard instances
	 * in the persistence layer than match the template attribute with the given value
	 *
	 * @param template to match
	 * @return the {@link List} of instances
	 */
    public List<Dashboard> findByTemplate(String template);
}
