package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoIndicatorDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Indicator.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Indicator
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoIndicatorDAOImpl implements IAutoIndicatorDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Indicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Indicator> getIndicatorDataSet()
    {
        return new HibernateDataSet<Indicator>(Indicator.class, this, Indicator.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoIndicatorDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Indicator object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Indicator transientInstance) {
        logger.debug("persisting Indicator instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Indicator in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Indicator instance) {
        logger.debug("attaching dirty Indicator instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Indicator instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Indicator instance) {
        logger.debug("attaching clean Indicator instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Indicator instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Indicator persistentInstance) {
        logger.debug("deleting Indicator instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Indicator instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Indicator merge(Indicator detachedInstance) {
        logger.debug("merging Indicator instance");
        Indicator result = (Indicator) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Indicator instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Indicator findById( java.lang.Long id) {
        logger.debug("getting Indicator instance with id: " + id);
        Indicator instance = (Indicator) getSession()
                .get(Indicator.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Indicator> findAll() {

 		List<Indicator> instances = new ArrayList<Indicator>();
		logger.debug("getting all Indicator instances");
        instances = getSession().createCriteria(Indicator.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Indicator>) instances;
    }


	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Indicator> findByExample(Indicator instance) {
        logger.debug("finding Indicator instance by example");
        List<Indicator> results = (List<Indicator>) getSession()
                .createCriteria(Indicator.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Indicator> findByFieldParcial(Indicator.Fields field, String value) {
        logger.debug("finding Indicator instance by parcial value: "+field+" like "+value);
        List<Indicator> results = (List<Indicator>) getSession()
                .createCriteria(Indicator.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the uniqueId attribute with the given value
	 *
	 * @param uniqueId to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByUniqueId(String uniqueId) {
        Indicator instance = new Indicator();

        instance.setUniqueId(uniqueId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the definitionType attribute with the given value
	 *
	 * @param definitionType to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByDefinitionType(Character definitionType) {
        Indicator instance = new Indicator();

        instance.setDefinitionType(definitionType);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByTitle(String title) {
        Indicator instance = new Indicator();

        instance.setTitle(title);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByDescription(String description) {
        Indicator instance = new Indicator();

        instance.setDescription(description);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the descriptionTitle attribute with the given value
	 *
	 * @param descriptionTitle to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByDescriptionTitle(String descriptionTitle) {
        Indicator instance = new Indicator();

        instance.setDescriptionTitle(descriptionTitle);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the groupTitle attribute with the given value
	 *
	 * @param groupTitle to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByGroupTitle(String groupTitle) {
        Indicator instance = new Indicator();

        instance.setGroupTitle(groupTitle);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the autoRefreshInt attribute with the given value
	 *
	 * @param autoRefreshInt to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByAutoRefreshInt(Long autoRefreshInt) {
        Indicator instance = new Indicator();

        instance.setAutoRefreshInt(autoRefreshInt);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the limitTopRecords attribute with the given value
	 *
	 * @param limitTopRecords to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByLimitTopRecords(Long limitTopRecords) {
        Indicator instance = new Indicator();

        instance.setLimitTopRecords(limitTopRecords);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the maxValue attribute with the given value
	 *
	 * @param maxValue to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByMaxValue(Long maxValue) {
        Indicator instance = new Indicator();

        instance.setMaxValue(maxValue);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the unitSuffix attribute with the given value
	 *
	 * @param unitSuffix to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByUnitSuffix(String unitSuffix) {
        Indicator instance = new Indicator();

        instance.setUnitSuffix(unitSuffix);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the axisXTitle attribute with the given value
	 *
	 * @param axisXTitle to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByAxisXTitle(String axisXTitle) {
        Indicator instance = new Indicator();

        instance.setAxisXTitle(axisXTitle);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the axisYTitle attribute with the given value
	 *
	 * @param axisYTitle to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByAxisYTitle(String axisYTitle) {
        Indicator instance = new Indicator();

        instance.setAxisYTitle(axisYTitle);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the totalField attribute with the given value
	 *
	 * @param totalField to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByTotalField(boolean totalField) {
        Indicator instance = new Indicator();

        instance.setTotalField(totalField);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the hideMarkers attribute with the given value
	 *
	 * @param hideMarkers to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByHideMarkers(boolean hideMarkers) {
        Indicator instance = new Indicator();

        instance.setHideMarkers(hideMarkers);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the legend attribute with the given value
	 *
	 * @param legend to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByLegend(boolean legend) {
        Indicator instance = new Indicator();

        instance.setLegend(legend);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the timeKeys attribute with the given value
	 *
	 * @param timeKeys to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByTimeKeys(boolean timeKeys) {
        Indicator instance = new Indicator();

        instance.setTimeKeys(timeKeys);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the useMinutes attribute with the given value
	 *
	 * @param useMinutes to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByUseMinutes(boolean useMinutes) {
        Indicator instance = new Indicator();

        instance.setUseMinutes(useMinutes);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the querySql attribute with the given value
	 *
	 * @param querySql to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByQuerySql(String querySql) {
        Indicator instance = new Indicator();

        instance.setQuerySql(querySql);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the viewsToRefresh attribute with the given value
	 *
	 * @param viewsToRefresh to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByViewsToRefresh(String viewsToRefresh) {
        Indicator instance = new Indicator();

        instance.setViewsToRefresh(viewsToRefresh);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the restrictGroups attribute with the given value
	 *
	 * @param restrictGroups to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByRestrictGroups(String restrictGroups) {
        Indicator instance = new Indicator();

        instance.setRestrictGroups(restrictGroups);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the restrictProfiles attribute with the given value
	 *
	 * @param restrictProfiles to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByRestrictProfiles(String restrictProfiles) {
        Indicator instance = new Indicator();

        instance.setRestrictProfiles(restrictProfiles);

        return findByExample(instance);
    }

}

