package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class EcommercePayments.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoEcommercePaymentsDAO extends IHibernateDAO<EcommercePayments> {

    /**
     * Obtains a new DataSet for the EcommercePayments entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<EcommercePayments> getEcommercePaymentsDataSet();

	/**
	 * Persist a EcommercePayments object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(EcommercePayments transientInstance);

	/**
	 * Updates a modified EcommercePayments in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(EcommercePayments instance);

	/**
	 * Attach an unmodified EcommercePayments instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(EcommercePayments instance);

	/**
	 * Removes a EcommercePayments instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(EcommercePayments persistentInstance);

	/**
	 * Merge a EcommercePayments instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public EcommercePayments merge(EcommercePayments detachedInstance);

	/**
	 * Finds a EcommercePayments instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public EcommercePayments findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findAll();


	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByFieldParcial(EcommercePayments.Fields field, String value);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the businessId attribute with the given value
	 *
	 * @param businessId to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByBusinessId(String businessId);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the transactionId attribute with the given value
	 *
	 * @param transactionId to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByTransactionId(String transactionId);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the creator attribute with the given value
	 *
	 * @param creator to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByCreator(String creator);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the businessContext attribute with the given value
	 *
	 * @param businessContext to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByBusinessContext(String businessContext);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the ecommerceProcessor attribute with the given value
	 *
	 * @param ecommerceProcessor to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByEcommerceProcessor(String ecommerceProcessor);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the paymentValue attribute with the given value
	 *
	 * @param paymentValue to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByPaymentValue(BigDecimal paymentValue);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the status attribute with the given value
	 *
	 * @param status to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByStatus(String status);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the statusMessage attribute with the given value
	 *
	 * @param statusMessage to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByStatusMessage(String statusMessage);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the securityToken attribute with the given value
	 *
	 * @param securityToken to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findBySecurityToken(String securityToken);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the dateCreation attribute with the given value
	 *
	 * @param dateCreation to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByDateCreation(Timestamp dateCreation);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the dateReceived attribute with the given value
	 *
	 * @param dateReceived to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByDateReceived(Timestamp dateReceived);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the dateProcessed attribute with the given value
	 *
	 * @param dateProcessed to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByDateProcessed(Timestamp dateProcessed);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the transactionDate attribute with the given value
	 *
	 * @param transactionDate to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByTransactionDate(Timestamp transactionDate);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the authorizationId attribute with the given value
	 *
	 * @param authorizationId to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByAuthorizationId(String authorizationId);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the redirectUrl attribute with the given value
	 *
	 * @param redirectUrl to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByRedirectUrl(String redirectUrl);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the configurationId attribute with the given value
	 *
	 * @param configurationId to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByConfigurationId(String configurationId);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the sentOnReport attribute with the given value
	 *
	 * @param sentOnReport to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findBySentOnReport(boolean sentOnReport);

	/**
	 * Gets a {@link List} of all EcommercePayments instances
	 * in the persistence layer than match the paymentContext attribute with the given value
	 *
	 * @param paymentContext to match
	 * @return the {@link List} of instances
	 */
    public List<EcommercePayments> findByPaymentContext(String paymentContext);
}
