package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoReportInstanceDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportInstance.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoReportInstanceDAOImpl implements IAutoReportInstanceDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportInstance entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstance> getReportInstanceDataSet()
    {
        return new HibernateDataSet<ReportInstance>(ReportInstance.class, this, ReportInstance.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoReportInstanceDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportInstance object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportInstance transientInstance) {
        logger.debug("persisting ReportInstance instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportInstance in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportInstance instance) {
        logger.debug("attaching dirty ReportInstance instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportInstance instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportInstance instance) {
        logger.debug("attaching clean ReportInstance instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportInstance instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportInstance persistentInstance) {
        logger.debug("deleting ReportInstance instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportInstance instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportInstance merge(ReportInstance detachedInstance) {
        logger.debug("merging ReportInstance instance");
        ReportInstance result = (ReportInstance) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportInstance instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportInstance findById( java.lang.Long id) {
        logger.debug("getting ReportInstance instance with id: " + id);
        ReportInstance instance = (ReportInstance) getSession()
                .get(ReportInstance.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstance> findAll() {

 		List<ReportInstance> instances = new ArrayList<ReportInstance>();
		logger.debug("getting all ReportInstance instances");
        instances = getSession().createCriteria(ReportInstance.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportInstance>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportInstance> findByExample(ReportInstance instance) {
        logger.debug("finding ReportInstance instance by example");
        List<ReportInstance> results = (List<ReportInstance>) getSession()
                .createCriteria(ReportInstance.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstance> findByFieldParcial(ReportInstance.Fields field, String value) {
        logger.debug("finding ReportInstance instance by parcial value: "+field+" like "+value);
        List<ReportInstance> results = (List<ReportInstance>) getSession()
                .createCriteria(ReportInstance.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByTitle(String title) {
        ReportInstance instance = new ReportInstance();

        instance.setTitle(title);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the readonly attribute with the given value
	 *
	 * @param readonly to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByReadonly(boolean readonly) {
        ReportInstance instance = new ReportInstance();

        instance.setReadonly(readonly);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the businessKey attribute with the given value
	 *
	 * @param businessKey to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByBusinessKey(String businessKey) {
        ReportInstance instance = new ReportInstance();

        instance.setBusinessKey(businessKey);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstance instances
	 * in the persistence layer than match the documentId attribute with the given value
	 *
	 * @param documentId to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstance> findByDocumentId(Long documentId) {
        ReportInstance instance = new ReportInstance();

        instance.setDocumentId(documentId);

        return findByExample(instance);
    }

}

