package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequest;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoUserDataRequestDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class UserDataRequest.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequest
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoUserDataRequestDAOImpl implements IAutoUserDataRequestDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the UserDataRequest entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserDataRequest> getUserDataRequestDataSet()
    {
        return new HibernateDataSet<UserDataRequest>(UserDataRequest.class, this, UserDataRequest.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoUserDataRequestDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a UserDataRequest object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(UserDataRequest transientInstance) {
        logger.debug("persisting UserDataRequest instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified UserDataRequest in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(UserDataRequest instance) {
        logger.debug("attaching dirty UserDataRequest instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified UserDataRequest instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(UserDataRequest instance) {
        logger.debug("attaching clean UserDataRequest instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a UserDataRequest instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(UserDataRequest persistentInstance) {
        logger.debug("deleting UserDataRequest instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a UserDataRequest instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public UserDataRequest merge(UserDataRequest detachedInstance) {
        logger.debug("merging UserDataRequest instance");
        UserDataRequest result = (UserDataRequest) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a UserDataRequest instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public UserDataRequest findById( java.lang.Long id) {
        logger.debug("getting UserDataRequest instance with id: " + id);
        UserDataRequest instance = (UserDataRequest) getSession()
                .get(UserDataRequest.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<UserDataRequest> findAll() {

 		List<UserDataRequest> instances = new ArrayList<UserDataRequest>();
		logger.debug("getting all UserDataRequest instances");
        instances = getSession().createCriteria(UserDataRequest.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<UserDataRequest>) instances;
    }


	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<UserDataRequest> findByExample(UserDataRequest instance) {
        logger.debug("finding UserDataRequest instance by example");
        List<UserDataRequest> results = (List<UserDataRequest>) getSession()
                .createCriteria(UserDataRequest.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<UserDataRequest> findByFieldParcial(UserDataRequest.Fields field, String value) {
        logger.debug("finding UserDataRequest instance by parcial value: "+field+" like "+value);
        List<UserDataRequest> results = (List<UserDataRequest>) getSession()
                .createCriteria(UserDataRequest.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the configId attribute with the given value
	 *
	 * @param configId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByConfigId(String configId) {
        UserDataRequest instance = new UserDataRequest();

        instance.setConfigId(configId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the requestType attribute with the given value
	 *
	 * @param requestType to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByRequestType(String requestType) {
        UserDataRequest instance = new UserDataRequest();

        instance.setRequestType(requestType);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByUserId(String userId) {
        UserDataRequest instance = new UserDataRequest();

        instance.setUserId(userId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByTitle(String title) {
        UserDataRequest instance = new UserDataRequest();

        instance.setTitle(title);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the requestDate attribute with the given value
	 *
	 * @param requestDate to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByRequestDate(Timestamp requestDate) {
        UserDataRequest instance = new UserDataRequest();

        instance.setRequestDate(requestDate);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the body attribute with the given value
	 *
	 * @param body to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByBody(String body) {
        UserDataRequest instance = new UserDataRequest();

        instance.setBody(body);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the handlerUserId attribute with the given value
	 *
	 * @param handlerUserId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByHandlerUserId(String handlerUserId) {
        UserDataRequest instance = new UserDataRequest();

        instance.setHandlerUserId(handlerUserId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the closeDate attribute with the given value
	 *
	 * @param closeDate to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByCloseDate(Timestamp closeDate) {
        UserDataRequest instance = new UserDataRequest();

        instance.setCloseDate(closeDate);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the responseDocumentId attribute with the given value
	 *
	 * @param responseDocumentId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByResponseDocumentId(Long responseDocumentId) {
        UserDataRequest instance = new UserDataRequest();

        instance.setResponseDocumentId(responseDocumentId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the state attribute with the given value
	 *
	 * @param state to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByState(String state) {
        UserDataRequest instance = new UserDataRequest();

        instance.setState(state);

        return findByExample(instance);
    }

}

