package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IReportManagerService;
import pt.digitalis.dif.dem.managers.impl.model.dao.ISqlDataSourceDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.SqlDataSourceDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.SqlDataSource;
import pt.digitalis.dif.dem.managers.impl.model.dao.IReportTemplateDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ReportTemplateDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate;
import pt.digitalis.dif.dem.managers.impl.model.dao.IReportTemplateAreaDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ReportTemplateAreaDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateArea;
import pt.digitalis.dif.dem.managers.impl.model.dao.IReportTemplateAreaTransDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ReportTemplateAreaTransDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateAreaTrans;
import pt.digitalis.dif.dem.managers.impl.model.dao.IReportTemplateAreaSqlDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ReportTemplateAreaSqlDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateAreaSql;
import pt.digitalis.dif.dem.managers.impl.model.dao.IReportInstanceDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ReportInstanceDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance;
import pt.digitalis.dif.dem.managers.impl.model.dao.IReportInstanceAreaDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ReportInstanceAreaDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceArea;
import pt.digitalis.dif.dem.managers.impl.model.dao.IReportInstanceAreaSqlDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ReportInstanceAreaSqlDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceAreaSql;
import pt.digitalis.dif.dem.managers.impl.model.dao.IReportInstanceAreaTransDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.ReportInstanceAreaTransDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceAreaTrans;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class ReportManagerServiceImpl implements IReportManagerService {

	/**
	 * Obtains a new SqlDataSource DAO
	 *
	 * @return A new ISqlDataSourceDAO
	 */
    public ISqlDataSourceDAO getSqlDataSourceDAO() {
    	return new SqlDataSourceDAOImpl();
    }

    /**
     * Obtains a new DataSet for the SqlDataSource entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<SqlDataSource> getSqlDataSourceDataSet() {
        return new HibernateDataSet<SqlDataSource>(SqlDataSource.class, new SqlDataSourceDAOImpl(),
                SqlDataSource.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ReportTemplate DAO
	 *
	 * @return A new IReportTemplateDAO
	 */
    public IReportTemplateDAO getReportTemplateDAO() {
    	return new ReportTemplateDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ReportTemplate entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplate> getReportTemplateDataSet() {
        return new HibernateDataSet<ReportTemplate>(ReportTemplate.class, new ReportTemplateDAOImpl(),
                ReportTemplate.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ReportTemplateArea DAO
	 *
	 * @return A new IReportTemplateAreaDAO
	 */
    public IReportTemplateAreaDAO getReportTemplateAreaDAO() {
    	return new ReportTemplateAreaDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ReportTemplateArea entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplateArea> getReportTemplateAreaDataSet() {
        return new HibernateDataSet<ReportTemplateArea>(ReportTemplateArea.class, new ReportTemplateAreaDAOImpl(),
                ReportTemplateArea.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ReportTemplateAreaTrans DAO
	 *
	 * @return A new IReportTemplateAreaTransDAO
	 */
    public IReportTemplateAreaTransDAO getReportTemplateAreaTransDAO() {
    	return new ReportTemplateAreaTransDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ReportTemplateAreaTrans entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplateAreaTrans> getReportTemplateAreaTransDataSet() {
        return new HibernateDataSet<ReportTemplateAreaTrans>(ReportTemplateAreaTrans.class, new ReportTemplateAreaTransDAOImpl(),
                ReportTemplateAreaTrans.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ReportTemplateAreaSql DAO
	 *
	 * @return A new IReportTemplateAreaSqlDAO
	 */
    public IReportTemplateAreaSqlDAO getReportTemplateAreaSqlDAO() {
    	return new ReportTemplateAreaSqlDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ReportTemplateAreaSql entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplateAreaSql> getReportTemplateAreaSqlDataSet() {
        return new HibernateDataSet<ReportTemplateAreaSql>(ReportTemplateAreaSql.class, new ReportTemplateAreaSqlDAOImpl(),
                ReportTemplateAreaSql.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ReportInstance DAO
	 *
	 * @return A new IReportInstanceDAO
	 */
    public IReportInstanceDAO getReportInstanceDAO() {
    	return new ReportInstanceDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ReportInstance entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstance> getReportInstanceDataSet() {
        return new HibernateDataSet<ReportInstance>(ReportInstance.class, new ReportInstanceDAOImpl(),
                ReportInstance.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ReportInstanceArea DAO
	 *
	 * @return A new IReportInstanceAreaDAO
	 */
    public IReportInstanceAreaDAO getReportInstanceAreaDAO() {
    	return new ReportInstanceAreaDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ReportInstanceArea entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstanceArea> getReportInstanceAreaDataSet() {
        return new HibernateDataSet<ReportInstanceArea>(ReportInstanceArea.class, new ReportInstanceAreaDAOImpl(),
                ReportInstanceArea.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ReportInstanceAreaSql DAO
	 *
	 * @return A new IReportInstanceAreaSqlDAO
	 */
    public IReportInstanceAreaSqlDAO getReportInstanceAreaSqlDAO() {
    	return new ReportInstanceAreaSqlDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ReportInstanceAreaSql entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstanceAreaSql> getReportInstanceAreaSqlDataSet() {
        return new HibernateDataSet<ReportInstanceAreaSql>(ReportInstanceAreaSql.class, new ReportInstanceAreaSqlDAOImpl(),
                ReportInstanceAreaSql.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ReportInstanceAreaTrans DAO
	 *
	 * @return A new IReportInstanceAreaTransDAO
	 */
    public IReportInstanceAreaTransDAO getReportInstanceAreaTransDAO() {
    	return new ReportInstanceAreaTransDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ReportInstanceAreaTrans entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstanceAreaTrans> getReportInstanceAreaTransDataSet() {
        return new HibernateDataSet<ReportInstanceAreaTrans>(ReportInstanceAreaTrans.class, new ReportInstanceAreaTransDAOImpl(),
                ReportInstanceAreaTrans.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == SqlDataSource.class)
            return getSqlDataSourceDataSet();

        if (clazz == ReportTemplate.class)
            return getReportTemplateDataSet();

        if (clazz == ReportTemplateArea.class)
            return getReportTemplateAreaDataSet();

        if (clazz == ReportTemplateAreaTrans.class)
            return getReportTemplateAreaTransDataSet();

        if (clazz == ReportTemplateAreaSql.class)
            return getReportTemplateAreaSqlDataSet();

        if (clazz == ReportInstance.class)
            return getReportInstanceDataSet();

        if (clazz == ReportInstanceArea.class)
            return getReportInstanceAreaDataSet();

        if (clazz == ReportInstanceAreaSql.class)
            return getReportInstanceAreaSqlDataSet();

        if (clazz == ReportInstanceAreaTrans.class)
            return getReportInstanceAreaTransDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(SqlDataSource.class.getSimpleName()))
            return getSqlDataSourceDataSet();

        if (entityName.equalsIgnoreCase(ReportTemplate.class.getSimpleName()))
            return getReportTemplateDataSet();

        if (entityName.equalsIgnoreCase(ReportTemplateArea.class.getSimpleName()))
            return getReportTemplateAreaDataSet();

        if (entityName.equalsIgnoreCase(ReportTemplateAreaTrans.class.getSimpleName()))
            return getReportTemplateAreaTransDataSet();

        if (entityName.equalsIgnoreCase(ReportTemplateAreaSql.class.getSimpleName()))
            return getReportTemplateAreaSqlDataSet();

        if (entityName.equalsIgnoreCase(ReportInstance.class.getSimpleName()))
            return getReportInstanceDataSet();

        if (entityName.equalsIgnoreCase(ReportInstanceArea.class.getSimpleName()))
            return getReportInstanceAreaDataSet();

        if (entityName.equalsIgnoreCase(ReportInstanceAreaSql.class.getSimpleName()))
            return getReportInstanceAreaSqlDataSet();

        if (entityName.equalsIgnoreCase(ReportInstanceAreaTrans.class.getSimpleName()))
            return getReportInstanceAreaTransDataSet();

        return null;
    }
}