/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoAreaDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Area;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoAreaDAOImpl
implements IAutoAreaDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Area> getAreaDataSet() {
        return new HibernateDataSet(Area.class, (IHibernateDAO)this, Area.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Area transientInstance) {
        this.logger.debug((Object)"persisting Area instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Area instance) {
        this.logger.debug((Object)"attaching dirty Area instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Area instance) {
        this.logger.debug((Object)"attaching clean Area instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Area persistentInstance) {
        this.logger.debug((Object)"deleting Area instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Area merge(Area detachedInstance) {
        this.logger.debug((Object)"merging Area instance");
        Area result = (Area)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Area findById(Long id) {
        this.logger.debug((Object)("getting Area instance with id: " + id));
        Area instance = (Area)this.getSession().get(Area.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Area> findAll() {
        List<Area> instances = new ArrayList();
        this.logger.debug((Object)"getting all Area instances");
        instances = this.getSession().createCriteria(Area.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Area> findByExample(Area instance) {
        this.logger.debug((Object)"finding Area instance by example");
        List results = this.getSession().createCriteria(Area.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Area> findByFieldParcial(Area.Fields field, String value) {
        this.logger.debug((Object)("finding Area instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Area.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Area> findByUniqueId(String uniqueId) {
        Area instance = new Area();
        instance.setUniqueId(uniqueId);
        return this.findByExample(instance);
    }

    @Override
    public List<Area> findByTitle(String title) {
        Area instance = new Area();
        instance.setTitle(title);
        return this.findByExample(instance);
    }

    @Override
    public List<Area> findByDatabaseUrl(String databaseUrl) {
        Area instance = new Area();
        instance.setDatabaseUrl(databaseUrl);
        return this.findByExample(instance);
    }

    @Override
    public List<Area> findByDatabaseUser(String databaseUser) {
        Area instance = new Area();
        instance.setDatabaseUser(databaseUser);
        return this.findByExample(instance);
    }

    @Override
    public List<Area> findByDatabasePass(String databasePass) {
        Area instance = new Area();
        instance.setDatabasePass(databasePass);
        return this.findByExample(instance);
    }

    @Override
    public List<Area> findByRestrictGroups(String restrictGroups) {
        Area instance = new Area();
        instance.setRestrictGroups(restrictGroups);
        return this.findByExample(instance);
    }

    @Override
    public List<Area> findByRestrictProfiles(String restrictProfiles) {
        Area instance = new Area();
        instance.setRestrictProfiles(restrictProfiles);
        return this.findByExample(instance);
    }
}

