/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoFilterDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Filter;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoFilterDAOImpl
implements IAutoFilterDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Filter> getFilterDataSet() {
        return new HibernateDataSet(Filter.class, (IHibernateDAO)this, Filter.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Filter transientInstance) {
        this.logger.debug((Object)"persisting Filter instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Filter instance) {
        this.logger.debug((Object)"attaching dirty Filter instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Filter instance) {
        this.logger.debug((Object)"attaching clean Filter instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Filter persistentInstance) {
        this.logger.debug((Object)"deleting Filter instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Filter merge(Filter detachedInstance) {
        this.logger.debug((Object)"merging Filter instance");
        Filter result = (Filter)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Filter findById(Long id) {
        this.logger.debug((Object)("getting Filter instance with id: " + id));
        Filter instance = (Filter)this.getSession().get(Filter.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Filter> findAll() {
        List<Filter> instances = new ArrayList();
        this.logger.debug((Object)"getting all Filter instances");
        instances = this.getSession().createCriteria(Filter.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Filter> findByExample(Filter instance) {
        this.logger.debug((Object)"finding Filter instance by example");
        List results = this.getSession().createCriteria(Filter.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Filter> findByFieldParcial(Filter.Fields field, String value) {
        this.logger.debug((Object)("finding Filter instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Filter.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Filter> findByUniqueId(String uniqueId) {
        Filter instance = new Filter();
        instance.setUniqueId(uniqueId);
        return this.findByExample(instance);
    }

    @Override
    public List<Filter> findByTitle(String title) {
        Filter instance = new Filter();
        instance.setTitle(title);
        return this.findByExample(instance);
    }

    @Override
    public List<Filter> findByDescription(String description) {
        Filter instance = new Filter();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<Filter> findByBindToProfile(String bindToProfile) {
        Filter instance = new Filter();
        instance.setBindToProfile(bindToProfile);
        return this.findByExample(instance);
    }

    @Override
    public List<Filter> findByType(Character type) {
        Filter instance = new Filter();
        instance.setType(type);
        return this.findByExample(instance);
    }

    @Override
    public List<Filter> findByDefaultValue(String defaultValue) {
        Filter instance = new Filter();
        instance.setDefaultValue(defaultValue);
        return this.findByExample(instance);
    }

    @Override
    public List<Filter> findBySqlTemplate(String sqlTemplate) {
        Filter instance = new Filter();
        instance.setSqlTemplate(sqlTemplate);
        return this.findByExample(instance);
    }

    @Override
    public List<Filter> findByItemsQuerySql(String itemsQuerySql) {
        Filter instance = new Filter();
        instance.setItemsQuerySql(itemsQuerySql);
        return this.findByExample(instance);
    }

    @Override
    public List<Filter> findByItemsList(String itemsList) {
        Filter instance = new Filter();
        instance.setItemsList(itemsList);
        return this.findByExample(instance);
    }
}

