/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoGroupsDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Groups;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoGroupsDAOImpl
implements IAutoGroupsDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Groups> getGroupsDataSet() {
        return new HibernateDataSet(Groups.class, (IHibernateDAO)this, Groups.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Groups transientInstance) {
        this.logger.debug((Object)"persisting Groups instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Groups instance) {
        this.logger.debug((Object)"attaching dirty Groups instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Groups instance) {
        this.logger.debug((Object)"attaching clean Groups instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Groups persistentInstance) {
        this.logger.debug((Object)"deleting Groups instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Groups merge(Groups detachedInstance) {
        this.logger.debug((Object)"merging Groups instance");
        Groups result = (Groups)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Groups findById(String id) {
        this.logger.debug((Object)("getting Groups instance with id: " + id));
        Groups instance = (Groups)this.getSession().get(Groups.class, (Serializable)((Object)id));
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Groups> findAll() {
        List<Groups> instances = new ArrayList();
        this.logger.debug((Object)"getting all Groups instances");
        instances = this.getSession().createCriteria(Groups.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Groups> findByExample(Groups instance) {
        this.logger.debug((Object)"finding Groups instance by example");
        List results = this.getSession().createCriteria(Groups.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Groups> findByFieldParcial(Groups.Fields field, String value) {
        this.logger.debug((Object)("finding Groups instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Groups.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Groups> findByName(String name) {
        Groups instance = new Groups();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public List<Groups> findByDescription(String description) {
        Groups instance = new Groups();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<Groups> findByDefaultGroup(boolean defaultGroup) {
        Groups instance = new Groups();
        instance.setDefaultGroup(defaultGroup);
        return this.findByExample(instance);
    }
}

