/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoSqlDataSourceDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.SqlDataSource;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoSqlDataSourceDAOImpl
implements IAutoSqlDataSourceDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<SqlDataSource> getSqlDataSourceDataSet() {
        return new HibernateDataSet(SqlDataSource.class, (IHibernateDAO)this, SqlDataSource.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(SqlDataSource transientInstance) {
        this.logger.debug((Object)"persisting SqlDataSource instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(SqlDataSource instance) {
        this.logger.debug((Object)"attaching dirty SqlDataSource instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(SqlDataSource instance) {
        this.logger.debug((Object)"attaching clean SqlDataSource instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(SqlDataSource persistentInstance) {
        this.logger.debug((Object)"deleting SqlDataSource instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public SqlDataSource merge(SqlDataSource detachedInstance) {
        this.logger.debug((Object)"merging SqlDataSource instance");
        SqlDataSource result = (SqlDataSource)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public SqlDataSource findById(Long id) {
        this.logger.debug((Object)("getting SqlDataSource instance with id: " + id));
        SqlDataSource instance = (SqlDataSource)this.getSession().get(SqlDataSource.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<SqlDataSource> findAll() {
        List<SqlDataSource> instances = new ArrayList();
        this.logger.debug((Object)"getting all SqlDataSource instances");
        instances = this.getSession().createCriteria(SqlDataSource.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<SqlDataSource> findByExample(SqlDataSource instance) {
        this.logger.debug((Object)"finding SqlDataSource instance by example");
        List results = this.getSession().createCriteria(SqlDataSource.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<SqlDataSource> findByFieldParcial(SqlDataSource.Fields field, String value) {
        this.logger.debug((Object)("finding SqlDataSource instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(SqlDataSource.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<SqlDataSource> findByName(String name) {
        SqlDataSource instance = new SqlDataSource();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public List<SqlDataSource> findByUrl(String url) {
        SqlDataSource instance = new SqlDataSource();
        instance.setUrl(url);
        return this.findByExample(instance);
    }

    @Override
    public List<SqlDataSource> findByUserName(String userName) {
        SqlDataSource instance = new SqlDataSource();
        instance.setUserName(userName);
        return this.findByExample(instance);
    }

    @Override
    public List<SqlDataSource> findByPassword(String password) {
        SqlDataSource instance = new SqlDataSource();
        instance.setPassword(password);
        return this.findByExample(instance);
    }

    @Override
    public List<SqlDataSource> findByDialect(String dialect) {
        SqlDataSource instance = new SqlDataSource();
        instance.setDialect(dialect);
        return this.findByExample(instance);
    }
}

