/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoUserDataConsentDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataConsent;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoUserDataConsentDAOImpl
implements IAutoUserDataConsentDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<UserDataConsent> getUserDataConsentDataSet() {
        return new HibernateDataSet(UserDataConsent.class, (IHibernateDAO)this, UserDataConsent.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(UserDataConsent transientInstance) {
        this.logger.debug((Object)"persisting UserDataConsent instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(UserDataConsent instance) {
        this.logger.debug((Object)"attaching dirty UserDataConsent instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(UserDataConsent instance) {
        this.logger.debug((Object)"attaching clean UserDataConsent instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(UserDataConsent persistentInstance) {
        this.logger.debug((Object)"deleting UserDataConsent instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public UserDataConsent merge(UserDataConsent detachedInstance) {
        this.logger.debug((Object)"merging UserDataConsent instance");
        UserDataConsent result = (UserDataConsent)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public UserDataConsent findById(Long id) {
        this.logger.debug((Object)("getting UserDataConsent instance with id: " + id));
        UserDataConsent instance = (UserDataConsent)this.getSession().get(UserDataConsent.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<UserDataConsent> findAll() {
        List<UserDataConsent> instances = new ArrayList();
        this.logger.debug((Object)"getting all UserDataConsent instances");
        instances = this.getSession().createCriteria(UserDataConsent.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<UserDataConsent> findByExample(UserDataConsent instance) {
        this.logger.debug((Object)"finding UserDataConsent instance by example");
        List results = this.getSession().createCriteria(UserDataConsent.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<UserDataConsent> findByFieldParcial(UserDataConsent.Fields field, String value) {
        this.logger.debug((Object)("finding UserDataConsent instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(UserDataConsent.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<UserDataConsent> findByUserId(String userId) {
        UserDataConsent instance = new UserDataConsent();
        instance.setUserId(userId);
        return this.findByExample(instance);
    }

    @Override
    public List<UserDataConsent> findByDateGiven(Timestamp dateGiven) {
        UserDataConsent instance = new UserDataConsent();
        instance.setDateGiven(dateGiven);
        return this.findByExample(instance);
    }

    @Override
    public List<UserDataConsent> findByDateConfirmed(Timestamp dateConfirmed) {
        UserDataConsent instance = new UserDataConsent();
        instance.setDateConfirmed(dateConfirmed);
        return this.findByExample(instance);
    }

    @Override
    public List<UserDataConsent> findByDateRevoked(Timestamp dateRevoked) {
        UserDataConsent instance = new UserDataConsent();
        instance.setDateRevoked(dateRevoked);
        return this.findByExample(instance);
    }

    @Override
    public List<UserDataConsent> findByProofDocumentId(Long proofDocumentId) {
        UserDataConsent instance = new UserDataConsent();
        instance.setProofDocumentId(proofDocumentId);
        return this.findByExample(instance);
    }

    @Override
    public List<UserDataConsent> findByState(String state) {
        UserDataConsent instance = new UserDataConsent();
        instance.setState(state);
        return this.findByExample(instance);
    }
}

