DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'TEMPLATE_REPOSITORY';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.TEMPLATE_REPOSITORY( '||
      '  id   		number not null, '||
      '  name 		varchar2(300) not null, '||
      '  language   varchar2(2) not null, '||
      '  content    clob not null '||
      ') ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'TEMPLATE_REPOSITORY'
  AND    CONSTRAINT_NAME = 'TEMPLATE_REPOSITORY_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.TEMPLATE_REPOSITORY ADD CONSTRAINT TEMPLATE_REPOSITORY_PK PRIMARY KEY (ID)';
  END IF;
END;
/

/* ## CRIAO DA SEQUNCIA DIF.TEMPLATE_REPOSITORY_ID_SEQ ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER = 'DIF'
  AND    SEQUENCE_NAME  = 'TEMPLATE_REPOSITORY_ID_SEQ';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.TEMPLATE_REPOSITORY_ID_SEQ START WITH 1 INCREMENT BY 1 MAXVALUE 9999999999999999999999999999 NOCACHE';
  END IF;
END;
/

/* ## ALTERAO DA TABELA DIF.TEMPLATE_REPOSITORY ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'TEMPLATE_REPOSITORY'
  AND    CONSTRAINT_NAME = 'TEMPLATE_REPOSITORY_NAME_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.TEMPLATE_REPOSITORY '||
                      'ADD CONSTRAINT TEMPLATE_REPO_NAME_LANG_UK '||
                      'UNIQUE (NAME,language) '||
                      'USING INDEX TABLESPACE INDX '||
                      'STORAGE (INITIAL 250K NEXT 200K PCTINCREASE 20)';
  END IF;
END;
/