DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'ACCESS_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'create table DIF.ACCESS_LOG '||
      '( '||
      '  id             number not null, '||
      '  application_id varchar2(100) not null, '||
      '  service_id     varchar2(100) not null, '||
      '  stage_id       varchar2(100) not null, '||
      '  event_id       varchar2(100), '||
      '  request_type   char(1) not null, '||
      '  user_id        varchar2(30), '||
      '  access_date    date default sysdate not null, '||
      '  execution_time number(10) not null, '||
      '  client_ip      varchar2(40) not null, '||
      '  request_dump   clob '||
      ') ';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'ACCESS_LOG'
  AND    CONSTRAINT_NAME = 'ACCESS_LOG_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'alter table DIF.ACCESS_LOG add constraint ACCESS_LOG_PK primary key (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_ACCESS_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_ACCESS_LOG MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.ACCESS_LOG.id is 'ID column';
comment on column DIF.ACCESS_LOG.application_id is 'Aplication Identifier';
comment on column DIF.ACCESS_LOG.service_id is 'Service Identifier';
comment on column DIF.ACCESS_LOG.stage_id is 'Stage Identifier';
comment on column DIF.ACCESS_LOG.event_id is 'Event identifier (form submit, ajax event, document request...)';
comment on column DIF.ACCESS_LOG.request_type is 'Request type ([S]ubmit, [A]jax, [D]ocument, [P]age)';
comment on column DIF.ACCESS_LOG.user_id is 'User Identifier';
comment on column DIF.ACCESS_LOG.access_date is 'Request date/time';
comment on column DIF.ACCESS_LOG.execution_time is 'Time the request took to execute (view not included)';
comment on column DIF.ACCESS_LOG.client_ip is 'The client IP that made the request';
comment on column DIF.ACCESS_LOG.request_dump is 'The DIF request (when trace logging is enabled)';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO TOTAL
  FROM ALL_INDEXES
  WHERE  OWNER   = 'DIF'
  AND INDEX_NAME = 'AL_SERVICE_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.AL_SERVICE_IDX ON DIF.ACCESS_LOG (application_id, service_id, access_date)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO TOTAL
  FROM ALL_INDEXES
  WHERE  OWNER   = 'DIF'
  AND INDEX_NAME = 'AL_STAGE_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.AL_STAGE_IDX ON DIF.ACCESS_LOG (stage_id, access_date)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO TOTAL
  FROM ALL_INDEXES
  WHERE  OWNER   = 'DIF'
  AND INDEX_NAME = 'AL_DATE_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.AL_DATE_IDX ON DIF.ACCESS_LOG (access_date)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO TOTAL
  FROM ALL_INDEXES
  WHERE  OWNER   = 'DIF'
  AND INDEX_NAME = 'AL_USER_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.AL_USER_IDX ON DIF.ACCESS_LOG (user_id, access_date)';
  END IF;
END;
/


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER       = 'DIF'
  AND    TABLE_NAME  = 'ACCESS_LOG'
  AND    CONSTRAINT_NAME = 'REQUEST_TYPE_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'alter table DIF.ACCESS_LOG add constraint REQUEST_TYPE_CK check (REQUEST_TYPE IN (''P'',''S'',''A'',''D''))';
  END IF;
END;
/

--
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'ACCESS_LOG'
  AND    COLUMN_NAME = 'ERROR_REPORT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'ALTER TABLE DIF.ACCESS_LOG ADD ERROR_REPORT VARCHAR2(4000)' ;
  END IF;
END;
/

-- Create a trigger for auto PK generation
DECLARE TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TRIGGERS
   WHERE TRIGGER_NAME = 'TRG_ACCESS_LOG_BEFORE_INS'
     AND OWNER = 'COMQUEST';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER DIF.TRG_ACCESS_LOG_BEFORE_INS BEFORE INSERT ON DIF.ACCESS_LOG FOR EACH ROW ' ||
	                  'DECLARE BEGIN IF :NEW.ID IS NULL THEN :NEW.ID := SEQ_ID_ACCESS_LOG.NEXTVAL; END IF; '||
	                  'END TRG_ACCESS_LOG_BEFORE_INS;';
  END IF;
END;
/
