-------------------------------------------------------------
-- MANAGER Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'MANAGER';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.MANAGER( '||
      '  ID            NUMBER(10) NOT NULL, '||
      '  UNIQUE_ID     VARCHAR2(200) NOT NULL '||
      ') ';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.MANAGER.ID is 'ID column';
comment on column DIF.MANAGER.UNIQUE_ID is 'Business unique ID';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'MANAGER'
  AND    CONSTRAINT_NAME = 'MANAGER_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.MANAGER ADD CONSTRAINT MANAGER_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'MANAGER'
  AND    CONSTRAINT_NAME = 'MANAGER_UNIQUE_ID_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.MANAGER ADD CONSTRAINT MANAGER_UNIQUE_ID_UK UNIQUE (UNIQUE_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_MANAGER';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_MANAGER MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- AREA Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'CREATE TABLE DIF.AREA ' ||
						'( ' ||
						'  ID                NUMBER(10) NOT NULL, ' ||
                        '  UNIQUE_ID         VARCHAR2(200) NOT NULL, '||
						'  TITLE             VARCHAR2(500) NOT NULL, ' ||
						'  DATABASE_URL      VARCHAR2(2000), ' ||
						'  DATABASE_USER     VARCHAR2(500), ' ||
						'  DATABASE_PASS     VARCHAR2(100), ' ||
						'  RESTRICT_GROUPS   VARCHAR2(4000), ' ||
						'  RESTRICT_PROFILES VARCHAR2(4000), ' ||
						'  MANAGER_ID        NUMBER(10) NOT NULL ' ||
						')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.AREA.ID is 'ID column';
comment on column DIF.AREA.UNIQUE_ID is 'Business unique ID';
comment on column DIF.AREA.TITLE is 'The area title';
comment on column DIF.AREA.DATABASE_URL is 'BD URL to get data from';
comment on column DIF.AREA.DATABASE_USER is 'BD username to connect';
comment on column DIF.AREA.DATABASE_PASS is 'BD password to connect';
comment on column DIF.AREA.RESTRICT_GROUPS is 'List of default groups to restrict access to all area indicators';
comment on column DIF.AREA.RESTRICT_PROFILES is 'List of default profiles to restrict access to all area indicators';
comment on column DIF.AREA.MANAGER_ID is 'The parent manager ID';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'AREA'
  AND    CONSTRAINT_NAME = 'AREA_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.AREA ADD CONSTRAINT AREA_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'AREA'
  AND    CONSTRAINT_NAME = 'AREA_UNIQUE_ID_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.AREA ADD CONSTRAINT AREA_UNIQUE_ID_UK UNIQUE (UNIQUE_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'AREA'
  AND    CONSTRAINT_NAME = 'FK_AREA_MANAGER';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.AREA ADD CONSTRAINT FK_AREA_MANAGER FOREIGN KEY (MANAGER_ID) REFERENCES DIF.MANAGER (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_AREA MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- INDICATOR Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'CREATE TABLE DIF.INDICATOR ' ||
						'( ' ||
						'  ID                NUMBER(10) NOT NULL, ' ||
                        '  UNIQUE_ID         VARCHAR2(200) NOT NULL, '||
						'  DEFINITION_TYPE   CHAR(1) NOT NULL, ' ||
						'  AREA_ID           NUMBER(10) NOT NULL, ' ||
						'  TITLE             VARCHAR2(500) NOT NULL, ' ||
						'  DESCRIPTION       VARCHAR2(4000) NOT NULL, ' ||
						'  DESCRIPTION_TITLE VARCHAR2(500) NOT NULL, ' ||
						'  GROUP_TITLE       VARCHAR2(2000) NOT NULL, ' ||
						'  AUTO_REFRESH_INT  NUMBER(10), ' ||
						'  LIMIT_TOP_RECORDS NUMBER(3), ' ||
						'  MAX_VALUE         NUMBER(20), ' ||
						'  UNIT_SUFFIX       VARCHAR2(100), ' ||
						'  AXIS_X_TITLE      VARCHAR2(200), ' ||
						'  AXIS_Y_TITLE      VARCHAR2(200), ' ||
						'  TOTAL_FIELD       NUMBER(1) DEFAULT 0 NOT NULL, ' ||
						'  HIDE_MARKERS      NUMBER(1) DEFAULT 0 NOT NULL, ' ||
						'  LEGEND            NUMBER(1) DEFAULT 0 NOT NULL, ' ||
						'  TIME_KEYS         NUMBER(1) DEFAULT 0 NOT NULL, ' ||
						'  USE_MINUTES       NUMBER(1) DEFAULT 0 NOT NULL, ' ||
						'  QUERY_SQL         CLOB NOT NULL, ' ||
						'  VIEWS_TO_REFRESH  VARCHAR2(4000), ' ||
						'  RESTRICT_GROUPS   VARCHAR2(4000), ' ||
						'  RESTRICT_PROFILES VARCHAR2(4000) ' ||
						')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.INDICATOR.ID is 'ID column';
comment on column DIF.INDICATOR.UNIQUE_ID is 'Business unique ID';
comment on column DIF.INDICATOR.AREA_ID is 'The parent area ID';
comment on column DIF.INDICATOR.DEFINITION_TYPE is 'The indicator type of definition';
comment on column DIF.INDICATOR.TITLE is 'The indicator title';
comment on column DIF.INDICATOR.DESCRIPTION is 'The indicator description';
comment on column DIF.INDICATOR.DESCRIPTION_TITLE is 'The indicator title description';
comment on column DIF.INDICATOR.GROUP_TITLE is 'The group title';
comment on column DIF.INDICATOR.AUTO_REFRESH_INT is 'If auto-refresh is present (in ms)';
comment on column DIF.INDICATOR.LIMIT_TOP_RECORDS is 'Limit the first records';
comment on column DIF.INDICATOR.MAX_VALUE is 'The scale max value if rigid';
comment on column DIF.INDICATOR.UNIT_SUFFIX is 'The unix suffix';
comment on column DIF.INDICATOR.AXIS_X_TITLE is 'The title of the X axis';
comment on column DIF.INDICATOR.AXIS_Y_TITLE is 'The title of the y axis';
comment on column DIF.INDICATOR.TOTAL_FIELD is 'The total field if exists';
comment on column DIF.INDICATOR.HIDE_MARKERS is 'Hide markers in line charts';
comment on column DIF.INDICATOR.LEGEND is 'Show legend';
comment on column DIF.INDICATOR.TIME_KEYS is 'Time key values';
comment on column DIF.INDICATOR.QUERY_SQL is 'The SQL to gt the data from';
comment on column DIF.INDICATOR.USE_MINUTES is 'Show minutes';
comment on column DIF.INDICATOR.VIEWS_TO_REFRESH is 'The database view to refresh data for materialized or persistent pre calculated data sets';
comment on column DIF.INDICATOR.RESTRICT_GROUPS is 'List of groups to restrict access to the indicators';
comment on column DIF.INDICATOR.RESTRICT_PROFILES is 'List of profiles to restrict access to the indicators';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'INDICATOR'
  AND    CONSTRAINT_NAME = 'INDICATOR_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.INDICATOR ADD CONSTRAINT INDICATOR_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'INDICATOR'
  AND    CONSTRAINT_NAME = 'INDICATOR_UNIQUE_ID_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.INDICATOR ADD CONSTRAINT INDICATOR_UNIQUE_ID_UK UNIQUE (UNIQUE_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'INDICATOR'
  AND    CONSTRAINT_NAME = 'FK_INDICATOR_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.INDICATOR ADD CONSTRAINT FK_INDICATOR_AREA FOREIGN KEY (AREA_ID) REFERENCES DIF.AREA (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'INDICATOR'
  AND    CONSTRAINT_NAME = 'DEFINITION_TYPE_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.INDICATOR ADD CONSTRAINT DEFINITION_TYPE_CK CHECK (DEFINITION_TYPE IN (''C'',''D''))';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_INDICATOR MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- DASHBOARD Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DASHBOARD';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'CREATE TABLE DIF.DASHBOARD ' ||
						'( ' ||
						'  ID          NUMBER(10) NOT NULL, ' ||
                        '  UNIQUE_ID   VARCHAR2(200) NOT NULL, '||
						'  TITLE       VARCHAR2(500) NOT NULL, ' ||
						'  TEMPLATE    VARCHAR2(2000) NOT NULL, ' ||
						'  AREA_ID     NUMBER(10) NOT NULL ' ||
						')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.DASHBOARD.ID is 'ID column';
comment on column DIF.DASHBOARD.UNIQUE_ID is 'Business unique ID';
comment on column DIF.DASHBOARD.TITLE is 'The dashboard title';
comment on column DIF.DASHBOARD.TEMPLATE is 'The layout of the indocators contained in the dashboard';
comment on column DIF.DASHBOARD.AREA_ID is 'The parent area ID';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DASHBOARD'
  AND    CONSTRAINT_NAME = 'DASHBOARD_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DASHBOARD ADD CONSTRAINT DASHBOARD_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DASHBOARD'
  AND    CONSTRAINT_NAME = 'DASHBOARD_UNIQUE_ID_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DASHBOARD ADD CONSTRAINT DASHBOARD_UNIQUE_ID_UK UNIQUE (UNIQUE_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DASHBOARD'
  AND    CONSTRAINT_NAME = 'FK_DASHBOARD_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DASHBOARD ADD CONSTRAINT FK_DASHBOARD_AREA FOREIGN KEY (AREA_ID) REFERENCES DIF.AREA (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_DASHBOARD';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_DASHBOARD MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- DASHBOARD_INDICATOR Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DASHBOARD_INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'CREATE TABLE DIF.DASHBOARD_INDICATOR ' ||
						'( ' ||
						'  ID           NUMBER(10) NOT NULL, ' ||
						'  DASHBOARD_ID NUMBER(10) NOT NULL, ' ||
						'  INDICATOR_ID NUMBER(10) NOT NULL ' ||
						')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.DASHBOARD_INDICATOR.ID is 'ID column';
comment on column DIF.DASHBOARD_INDICATOR.DASHBOARD_ID is 'The dashboard ID';
comment on column DIF.DASHBOARD_INDICATOR.INDICATOR_ID is 'The indicator ID';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DASHBOARD_INDICATOR'
  AND    CONSTRAINT_NAME = 'DASHBOARD_INDICATOR_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DASHBOARD_INDICATOR ADD CONSTRAINT DASHBOARD_INDICATOR_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DASHBOARD_INDICATOR'
  AND    CONSTRAINT_NAME = 'FK_DASH_IND_DASHBOARD';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DASHBOARD_INDICATOR ADD CONSTRAINT FK_DASH_IND_DASHBOARD FOREIGN KEY (DASHBOARD_ID) REFERENCES DIF.DASHBOARD (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DASHBOARD_INDICATOR'
  AND    CONSTRAINT_NAME = 'FK_DASH_IND_INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DASHBOARD_INDICATOR ADD CONSTRAINT FK_DASH_IND_INDICATOR FOREIGN KEY (INDICATOR_ID) REFERENCES DIF.INDICATOR (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_DASHBOARD_INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_DASHBOARD_INDICATOR MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- SERIE Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'SERIE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'CREATE TABLE DIF.SERIE ' ||
						'( ' ||
						'  ID                NUMBER(10) NOT NULL, ' ||
						'  DESCRIPTION       VARCHAR2(4000), ' ||
						'  INDICATOR_ID      NUMBER(10) NOT NULL, ' ||
						'  UNIT_NAME         VARCHAR2(500), ' ||
						'  VALUE_FIELD       VARCHAR2(200), ' ||
						'  TYPE              CHAR(1) DEFAULT ''C'' NOT NULL ' ||
						')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.SERIE.ID is 'ID column';
comment on column DIF.SERIE.DESCRIPTION is 'The serie description';
comment on column DIF.SERIE.INDICATOR_ID is 'The parent indicator ID';
comment on column DIF.SERIE.UNIT_NAME is 'The serie data unit name';
comment on column DIF.SERIE.VALUE_FIELD is 'The field that has the value for this sirie';
comment on column DIF.SERIE.TYPE is 'The serie type';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERIE'
  AND    CONSTRAINT_NAME = 'SERIE_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERIE ADD CONSTRAINT SERIE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERIE'
  AND    CONSTRAINT_NAME = 'SERIE_TYPE_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERIE ADD CONSTRAINT SERIE_TYPE_CK CHECK (TYPE IN (''A'',''B'',''C'',''L'',''P''))';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SERIE'
  AND    CONSTRAINT_NAME = 'FK_SERIE_INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SERIE ADD CONSTRAINT FK_SERIE_INDICATOR FOREIGN KEY (INDICATOR_ID) REFERENCES DIF.INDICATOR (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_SERIE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_SERIE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- FILTER Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'FILTER';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'CREATE TABLE DIF.FILTER ' ||
						'( ' ||
						'  ID                NUMBER(10) NOT NULL, ' ||
                        '  UNIQUE_ID         VARCHAR2(200) NOT NULL, '||
						'  INDICATOR_ID      NUMBER(10) NOT NULL, ' ||
						'  TITLE             VARCHAR2(500) NOT NULL, ' ||
						'  DESCRIPTION       VARCHAR2(4000) NOT NULL, ' ||
						'  BIND_TO_PROFILE   VARCHAR2(100), ' ||
						'  TYPE              CHAR(1) DEFAULT ''T'' NOT NULL, ' ||
						'  DEFAULT_VALUE     VARCHAR2(500), ' ||
						'  SQL_TEMPLATE      VARCHAR2(4000), ' ||
						'  ITEMS_QUERY_SQL   VARCHAR2(4000), ' ||
						'  ITEMS_LIST        VARCHAR2(4000) ' ||
						')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.FILTER.ID is 'ID column';
comment on column DIF.FILTER.UNIQUE_ID is 'Business unique ID';
comment on column DIF.FILTER.INDICATOR_ID is 'The indicator ID';
comment on column DIF.FILTER.TITLE is 'The filter title';
comment on column DIF.FILTER.DESCRIPTION is 'The filter description';
comment on column DIF.FILTER.BIND_TO_PROFILE is 'The profile to bind this filter to (auto-apply filter to profile users)';
comment on column DIF.FILTER.TYPE is 'The filter type';
comment on column DIF.FILTER.DEFAULT_VALUE is 'The default filter value';
comment on column DIF.FILTER.SQL_TEMPLATE is 'The SQL template to apply to the indicator query when the filter is used';
comment on column DIF.FILTER.ITEMS_QUERY_SQL is 'The LOV SQL query';
comment on column DIF.FILTER.ITEMS_LIST is 'The LOV values';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'FILTER'
  AND    CONSTRAINT_NAME = 'FILTER_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILTER ADD CONSTRAINT FILTER_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'FILTER'
  AND    CONSTRAINT_NAME = 'FILTER_UNIQUE_ID_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILTER ADD CONSTRAINT FILTER_UNIQUE_ID_UK UNIQUE (INDICATOR_ID, UNIQUE_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'FILTER'
  AND    CONSTRAINT_NAME = 'FK_FILTER_INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILTER ADD CONSTRAINT FK_FILTER_INDICATOR FOREIGN KEY (INDICATOR_ID) REFERENCES DIF.INDICATOR (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'FILTER'
  AND    CONSTRAINT_NAME = 'FILTER_TYPE_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.FILTER ADD CONSTRAINT FILTER_TYPE_CK CHECK (TYPE IN (''B'',''D'',''L'',''N'',''T''))';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_FILTER';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_FILTER MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/
