-------------------------------------------------------------
-- REPORT TEMPLATE Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'REPORT_TEMPLATE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.REPORT_TEMPLATE( '||
      '  ID               NUMBER(10) NOT NULL, '||
      '  NAME             VARCHAR2(200) NOT NULL, '||
      '  DESCRIPTION      VARCHAR2(2000), '||
      '  TYPE             VARCHAR2(2) NOT NULL, '||
      '  ENABLED          NUMBER(1) NOT NULL, '||
      '  TEMPLATE_URL     VARCHAR2(2000) NOT NULL, '||
      '  TEMPLATE_FILES   BLOB, '||
      '  CONTEXT_CLASS_ID VARCHAR2(100) '||
      ') ';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.REPORT_TEMPLATE.ID is 'ID column';
comment on column DIF.REPORT_TEMPLATE.NAME is 'The report name';
comment on column DIF.REPORT_TEMPLATE.DESCRIPTION is 'the report description';
comment on column DIF.REPORT_TEMPLATE.TYPE is 'the report type';
comment on column DIF.REPORT_TEMPLATE.ENABLED is 'is the report is enabled';
comment on column DIF.REPORT_TEMPLATE.TEMPLATE_URL is 'the report template URL';
comment on column DIF.REPORT_TEMPLATE.TEMPLATE_FILES is 'a zip file with the report template and it''s assets';
comment on column DIF.REPORT_TEMPLATE.CONTEXT_CLASS_ID is 'the id of the context class implementation to provide resources and rules to this report';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE'
  AND    CONSTRAINT_NAME = 'REPORT_TEMPLATE_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE ADD CONSTRAINT REPORT_TEMPLATE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE'
  AND    CONSTRAINT_NAME = 'REPORT_TEMPLATE_TYPE_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE ADD CONSTRAINT REPORT_TEMPLATE_TYPE_CK CHECK (TYPE IN (''JR'',''FM''))';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_REPORT_TEMPLATE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_REPORT_TEMPLATE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- REPORT template areas Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'REPORT_TEMPLATE_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'CREATE TABLE DIF.REPORT_TEMPLATE_AREA ' ||
            '( ' ||
            '  ID                   NUMBER(10) NOT NULL, ' ||
                        '  REPORT_TEMPLATE_ID   NUMBER(10) NOT NULL, '||
            '  TITLE                VARCHAR2(200) NOT NULL, ' ||
            '  SHOW_TITLE           NUMBER(1) NOT NULL, ' ||
            '  POSITION             NUMBER(3) NOT NULL, ' ||
            '  CONTENT              CLOB NOT NULL, ' ||
            '  PRIVATE              NUMBER(1) NOT NULL, ' ||
            '  CUSTOMIZABLE         NUMBER(1) NOT NULL, ' ||
            '  MANDATORY            NUMBER(1) NOT NULL, ' ||
            '  TYPE                 VARCHAR2(10) NOT NULL, ' ||
            '  INDICATOR_ID         NUMBER(10), ' ||
            '  LANGUAGE             VARCHAR2(2), ' ||
            '  MAX_SIZE             NUMBER(6) ' ||
            ')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.REPORT_TEMPLATE_AREA.ID is 'ID column';
comment on column DIF.REPORT_TEMPLATE_AREA.REPORT_TEMPLATE_ID is 'The parent template ID';
comment on column DIF.REPORT_TEMPLATE_AREA.TITLE is 'The area title';
comment on column DIF.REPORT_TEMPLATE_AREA.SHOW_TITLE is 'if true show the area title';
comment on column DIF.REPORT_TEMPLATE_AREA.POSITION is 'the position of this area in the template';
comment on column DIF.REPORT_TEMPLATE_AREA.CONTENT is 'the content';
comment on column DIF.REPORT_TEMPLATE_AREA.PRIVATE is 'is the area is private';
comment on column DIF.REPORT_TEMPLATE_AREA.CUSTOMIZABLE is 'if the area is customizable in the report instance';
comment on column DIF.REPORT_TEMPLATE_AREA.MANDATORY is 'if the area is mandatory in the report instance';
comment on column DIF.REPORT_TEMPLATE_AREA.TYPE is 'the area type';
comment on column DIF.REPORT_TEMPLATE_AREA.INDICATOR_ID is 'the indicator id for Chart typed areas';
comment on column DIF.REPORT_TEMPLATE_AREA.LANGUAGE is 'the area content language for jasper areas to take into account when calculating the area context objects that the jasper template uses';
comment on column DIF.REPORT_TEMPLATE_AREA.MAX_SIZE is 'the content max size for html typed areas';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA'
  AND    CONSTRAINT_NAME = 'REPORT_TEMPLATE_AREA_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA ADD CONSTRAINT REPORT_TEMPLATE_AREA_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA'
  AND    CONSTRAINT_NAME = 'FK_REPORT_TEMPLATE_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA ADD CONSTRAINT FK_REPORT_TEMPLATE_AREA FOREIGN KEY (REPORT_TEMPLATE_ID) REFERENCES DIF.REPORT_TEMPLATE (ID) on delete cascade';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA'
  AND    CONSTRAINT_NAME = 'FK_REPORT_AREA_INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA ADD CONSTRAINT FK_REPORT_AREA_INDICATOR FOREIGN KEY (INDICATOR_ID) REFERENCES DIF.INDICATOR (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA'
  AND    CONSTRAINT_NAME = 'REPORT_TEMPLATE_AREA_TYPE_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA ADD CONSTRAINT REPORT_TEMPLATE_AREA_TYPE_CK CHECK (TYPE IN (''HTML'',''CHART'',''FM''))';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_REPORT_TEMPLATE_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_REPORT_TEMPLATE_AREA MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- REPORT template areas translations
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'REPORT_TEMPLATE_AREA_TRANS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'CREATE TABLE DIF.REPORT_TEMPLATE_AREA_TRANS ' ||
            '( ' ||
            '  ID                   NUMBER(10) NOT NULL, ' ||
                        '  REPORT_AREA_ID       NUMBER(10) NOT NULL, '||
            '  LANGUAGE             VARCHAR2(2), ' ||
            '  CONTENT              CLOB NOT NULL, ' ||
            '  TITLE                VARCHAR2(200) NOT NULL' ||            
            ')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.REPORT_TEMPLATE_AREA_TRANS.ID is 'ID column';
comment on column DIF.REPORT_TEMPLATE_AREA_TRANS.TITLE is 'The area title';
comment on column DIF.REPORT_TEMPLATE_AREA_TRANS.REPORT_AREA_ID is 'The parent area ID';
comment on column DIF.REPORT_TEMPLATE_AREA_TRANS.LANGUAGE is 'the language';
comment on column DIF.REPORT_TEMPLATE_AREA_TRANS.CONTENT is 'the content';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA_TRANS'
  AND    CONSTRAINT_NAME = 'REPORT_TEMPLATE_AREA_TRANS_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA_TRANS ADD CONSTRAINT REPORT_TEMPLATE_AREA_TRANS_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA_TRANS'
  AND    CONSTRAINT_NAME = 'REPORT_TEMPLATE_AREA_TRANS_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA_TRANS ADD CONSTRAINT REPORT_TEMPLATE_AREA_TRANS_UK UNIQUE (REPORT_AREA_ID,LANGUAGE)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA_TRANS'
  AND    CONSTRAINT_NAME = 'FK_REPORT_AREA_TRANS_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA_TRANS ADD CONSTRAINT FK_REPORT_AREA_TRANS_AREA FOREIGN KEY (REPORT_AREA_ID) REFERENCES DIF.REPORT_TEMPLATE_AREA (ID) on delete cascade';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_REPORT_AREA_TRANS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_REPORT_AREA_TRANS MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- SQL DataSources
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'SQL_DATA_SOURCE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'CREATE TABLE DIF.SQL_DATA_SOURCE ' ||
            '( ' ||
            '  ID                   NUMBER(10) NOT NULL, ' ||
                        '  NAME                 VARCHAR2(100) NOT NULL, '||
            '  URL                  VARCHAR2(500) NOT NULL, ' ||
            '  USER_NAME            VARCHAR2(100) NOT NULL, ' ||
            '  PASSWORD             VARCHAR2(100) NOT NULL, ' ||
            '  DIALECT              VARCHAR2(100) NOT NULL ' ||
            ')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.SQL_DATA_SOURCE.ID is 'ID column';
comment on column DIF.SQL_DATA_SOURCE.NAME is 'Name of the data source';
comment on column DIF.SQL_DATA_SOURCE.URL is 'URL to connect';
comment on column DIF.SQL_DATA_SOURCE.USER_NAME is 'User name to connect';
comment on column DIF.SQL_DATA_SOURCE.PASSWORD is 'Password to connect';
comment on column DIF.SQL_DATA_SOURCE.DIALECT is 'the database dialect';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'SQL_DATA_SOURCE'
  AND    CONSTRAINT_NAME = 'SQL_DATA_SOURCE_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.SQL_DATA_SOURCE ADD CONSTRAINT SQL_DATA_SOURCE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_SQL_DATA_SOURCE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_SQL_DATA_SOURCE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- REPORT template areas sql definitions
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'REPORT_TEMPLATE_AREA_SQL';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'CREATE TABLE DIF.REPORT_TEMPLATE_AREA_SQL ' ||
            '( ' ||
            '  ID                   NUMBER(10) NOT NULL, ' ||
            '  NAME                 VARCHAR2(100) NOT NULL, '||
            '  REPORT_AREA_ID       NUMBER(10) NOT NULL, '||
            '  SQL_DATA_SOURCE_ID   NUMBER(10), ' ||
            '  SQL                  CLOB NOT NULL ' ||
            ')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.REPORT_TEMPLATE_AREA_SQL.ID is 'ID column';
comment on column DIF.REPORT_TEMPLATE_AREA_SQL.NAME is 'The sql business name';
comment on column DIF.REPORT_TEMPLATE_AREA_SQL.REPORT_AREA_ID is 'the report area ID';
comment on column DIF.REPORT_TEMPLATE_AREA_SQL.SQL_DATA_SOURCE_ID is 'the data source ID';
comment on column DIF.REPORT_TEMPLATE_AREA_SQL.SQL is 'the SQL query';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA_SQL'
  AND    CONSTRAINT_NAME = 'REPORT_TEMPLATE_AREA_SQL_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA_SQL ADD CONSTRAINT REPORT_TEMPLATE_AREA_SQL_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA_SQL'
  AND    CONSTRAINT_NAME = 'FK_REPORT_AREA_SQL_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA_SQL ADD CONSTRAINT FK_REPORT_AREA_SQL_AREA FOREIGN KEY (REPORT_AREA_ID) REFERENCES DIF.REPORT_TEMPLATE_AREA (ID) on delete cascade';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_TEMPLATE_AREA_SQL'
  AND    CONSTRAINT_NAME = 'FK_REPORT_AREA_SQL_DS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_TEMPLATE_AREA_SQL ADD CONSTRAINT FK_REPORT_AREA_SQL_DS FOREIGN KEY (SQL_DATA_SOURCE_ID) REFERENCES DIF.SQL_DATA_SOURCE (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_REPORT_AREA_SQL';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_REPORT_AREA_SQL MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- REPORT instance
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'REPORT_INSTANCE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'CREATE TABLE DIF.REPORT_INSTANCE ' ||
            '( ' ||
            '  ID                   NUMBER(10) NOT NULL, ' ||
                        '  REPORT_TEMPLATE_ID   NUMBER(10) NOT NULL, '||
            '  TITLE                VARCHAR2(200) NOT NULL, ' ||
            '  READONLY             NUMBER(1) NOT NULL, ' ||
            '  BUSINESS_KEY         VARCHAR2(500), ' ||
            '  DOCUMENT_ID          NUMBER ' ||
            ')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.REPORT_INSTANCE.ID is 'ID column';
comment on column DIF.REPORT_INSTANCE.REPORT_TEMPLATE_ID is 'The parent template ID';
comment on column DIF.REPORT_INSTANCE.TITLE is 'The instance business title';
comment on column DIF.REPORT_INSTANCE.READONLY is 'if true this instance if readonly and cannot be changed';
comment on column DIF.REPORT_INSTANCE.BUSINESS_KEY is 'the business key this instance is associated to';
comment on column DIF.REPORT_INSTANCE.DOCUMENT_ID is 'the generated report file (document repository ID)';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE'
  AND    CONSTRAINT_NAME = 'REPORT_INSTANCE_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE ADD CONSTRAINT REPORT_INSTANCE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE'
  AND    CONSTRAINT_NAME = 'FK_REPORT_INSTANCE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE ADD CONSTRAINT FK_REPORT_INSTANCE FOREIGN KEY (REPORT_TEMPLATE_ID) REFERENCES DIF.REPORT_TEMPLATE (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_REPORT_INSTANCE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_REPORT_INSTANCE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- REPORT instance areas Table
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'REPORT_INSTANCE_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'CREATE TABLE DIF.REPORT_INSTANCE_AREA ' ||
            '( ' ||
            '  ID                       NUMBER(10) NOT NULL, ' ||
                        '  REPORT_INSTANCE_ID       NUMBER(10) NOT NULL, '||
                        '  REPORT_TEMPLATE_AREA_ID  NUMBER(10) NOT NULL, '||
            '  TITLE                  VARCHAR2(200) NOT NULL, ' ||
            '  SHOW_TITLE             NUMBER(1) NOT NULL, ' ||
            '  POSITION                  NUMBER(3) NOT NULL, ' ||
            '  CONTENT                CLOB NOT NULL, ' ||
            '  PRIVATE                NUMBER(1) NOT NULL, ' ||
            '  CUSTOMIZABLE           NUMBER(1) NOT NULL, ' ||
            '  MANDATORY              NUMBER(1) NOT NULL, ' ||
            '  TYPE                   VARCHAR2(10) NOT NULL, ' ||
            '  INDICATOR_ID           NUMBER(10), ' ||
            '  LANGUAGE               VARCHAR2(2), ' ||
            '  MAX_SIZE               NUMBER(6) ' ||
            ')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.REPORT_INSTANCE_AREA.ID is 'ID column';
comment on column DIF.REPORT_INSTANCE_AREA.REPORT_INSTANCE_ID is 'The parent report ID';
comment on column DIF.REPORT_INSTANCE_AREA.REPORT_TEMPLATE_AREA_ID is 'The parent template area ID';
comment on column DIF.REPORT_INSTANCE_AREA.TITLE is 'The area title';
comment on column DIF.REPORT_INSTANCE_AREA.SHOW_TITLE is 'if true show the area title';
comment on column DIF.REPORT_INSTANCE_AREA.POSITION is 'the position of this area in the template';
comment on column DIF.REPORT_INSTANCE_AREA.CONTENT is 'the content';
comment on column DIF.REPORT_INSTANCE_AREA.PRIVATE is 'is the area is private';
comment on column DIF.REPORT_INSTANCE_AREA.CUSTOMIZABLE is 'if the area is customizable in the report instance';
comment on column DIF.REPORT_INSTANCE_AREA.MANDATORY is 'if the area is mandatory in the report instance';
comment on column DIF.REPORT_INSTANCE_AREA.TYPE is 'the area type';
comment on column DIF.REPORT_INSTANCE_AREA.INDICATOR_ID is 'the indicator id for Chart typed areas';
comment on column DIF.REPORT_INSTANCE_AREA.LANGUAGE is 'the area content language for jasper areas to take into account when calculating the area context objects that the jasper template uses';
comment on column DIF.REPORT_INSTANCE_AREA.MAX_SIZE is 'the content max size for html typed areas';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA'
  AND    CONSTRAINT_NAME = 'REPORT_INSTANCE_AREA_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA ADD CONSTRAINT REPORT_INSTANCE_AREA_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA'
  AND    CONSTRAINT_NAME = 'FK_REPORT_INST_AREA_REP';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA ADD CONSTRAINT FK_REPORT_INST_AREA_REP FOREIGN KEY (REPORT_INSTANCE_ID) REFERENCES DIF.REPORT_INSTANCE (ID) on delete cascade';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA'
  AND    CONSTRAINT_NAME = 'FK_REP_INST_AREA_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA ADD CONSTRAINT FK_REP_INST_AREA_AREA FOREIGN KEY (REPORT_TEMPLATE_AREA_ID) REFERENCES DIF.REPORT_TEMPLATE_AREA (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA'
  AND    CONSTRAINT_NAME = 'FK_REP_INST_AREA_INDICATOR';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA ADD CONSTRAINT FK_REP_INST_AREA_INDICATOR FOREIGN KEY (INDICATOR_ID) REFERENCES DIF.INDICATOR (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA'
  AND    CONSTRAINT_NAME = 'REPORT_INSTANCE_AREA_TYPE_CK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA ADD CONSTRAINT REPORT_INSTANCE_AREA_TYPE_CK CHECK (TYPE IN (''HTML'',''CHART'',''FM''))';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_REPORT_INSTANCE_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_REPORT_INSTANCE_AREA MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- REPORT instance areas translations
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'REPORT_INSTANCE_AREA_TRANS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'CREATE TABLE DIF.REPORT_INSTANCE_AREA_TRANS ' ||
            '( ' ||
            '  ID                        NUMBER(10) NOT NULL, ' ||
            '  REPORT_INSTANCE_AREA_ID   NUMBER(10) NOT NULL, '||
            '  LANGUAGE                  VARCHAR2(2), ' ||
            '  CONTENT                   CLOB NOT NULL, ' ||
            '  TITLE                     VARCHAR2(200) NOT NULL' ||            
            ')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.REPORT_INSTANCE_AREA_TRANS.ID is 'ID column';
comment on column DIF.REPORT_INSTANCE_AREA_TRANS.TITLE is 'Area Title';
comment on column DIF.REPORT_INSTANCE_AREA_TRANS.REPORT_INSTANCE_AREA_ID is 'The parent area ID';
comment on column DIF.REPORT_INSTANCE_AREA_TRANS.LANGUAGE is 'the language';
comment on column DIF.REPORT_INSTANCE_AREA_TRANS.CONTENT is 'the content';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA_TRANS'
  AND    CONSTRAINT_NAME = 'REPORT_INSTANCE_AREA_TRANS_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA_TRANS ADD CONSTRAINT REPORT_INSTANCE_AREA_TRANS_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA_TRANS'
  AND    CONSTRAINT_NAME = 'REPORT_INSTANCE_AREA_TRANS_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA_TRANS ADD CONSTRAINT REPORT_INSTANCE_AREA_TRANS_UK UNIQUE (REPORT_INSTANCE_AREA_ID,LANGUAGE)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA_TRANS'
  AND    CONSTRAINT_NAME = 'FK_REP_INST_AREA_TRANS_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA_TRANS ADD CONSTRAINT FK_REP_INST_AREA_TRANS_AREA FOREIGN KEY (REPORT_INSTANCE_AREA_ID) REFERENCES DIF.REPORT_INSTANCE_AREA (ID) on delete cascade';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_REP_INST_AREA_TRANS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_REP_INST_AREA_TRANS MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

-------------------------------------------------------------
-- REPORT instance areas sql definitions
-------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'REPORT_INSTANCE_AREA_SQL';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'CREATE TABLE DIF.REPORT_INSTANCE_AREA_SQL ' ||
            '( ' ||
            '  ID                        NUMBER(10) NOT NULL, ' ||
            '  NAME                      VARCHAR2(100) NOT NULL, '||            
            '  REPORT_INSTANCE_AREA_ID   NUMBER(10) NOT NULL, '||
            '  SQL_DATA_SOURCE_ID        NUMBER(10), ' ||
            '  SQL                       CLOB NOT NULL ' ||
            ')';
  END IF;
END;
/

-- Add comments to the columns
comment on column DIF.REPORT_INSTANCE_AREA_SQL.ID is 'ID column';
comment on column DIF.REPORT_INSTANCE_AREA_SQL.NAME is 'the sql business name';
comment on column DIF.REPORT_INSTANCE_AREA_SQL.REPORT_INSTANCE_AREA_ID is 'the report instance area ID';
comment on column DIF.REPORT_INSTANCE_AREA_SQL.SQL_DATA_SOURCE_ID is 'the data source ID';
comment on column DIF.REPORT_INSTANCE_AREA_SQL.SQL is 'the SQL query';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA_SQL'
  AND    CONSTRAINT_NAME = 'REPORT_INSTANCE_AREA_SQL_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA_SQL ADD CONSTRAINT REPORT_INSTANCE_AREA_SQL_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA_SQL'
  AND    CONSTRAINT_NAME = 'FK_REP_INST_AREA_SQL_AREA';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA_SQL ADD CONSTRAINT FK_REP_INST_AREA_SQL_AREA FOREIGN KEY (REPORT_INSTANCE_AREA_ID) REFERENCES DIF.REPORT_INSTANCE_AREA (ID) on delete cascade';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'REPORT_INSTANCE_AREA_SQL'
  AND    CONSTRAINT_NAME = 'FK_REP_INST_AREA_SQL_DS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_AREA_SQL ADD CONSTRAINT FK_REP_INST_AREA_SQL_DS FOREIGN KEY (SQL_DATA_SOURCE_ID) REFERENCES DIF.SQL_DATA_SOURCE (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_REPORT_INST_AREA_SQL';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_REPORT_INST_AREA_SQL MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

