-----------------------------------------------------------------------------------------------------------------------
--- TABLE CONSENTS table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.DATA_CONSENT( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  CONFIG_ID              VARCHAR2(255) NOT NULL, '||
      '  BUSINESS_ID            VARCHAR2(255) NOT NULL, '||
      '  TITLE                  VARCHAR2(1000) NOT NULL, '||
      '  DESCRIPTION            CLOB, '||
      '  TEMPLATE_DOCUMENT_ID   NUMBER, '||
      '  PROFILE_ID             VARCHAR2(255), '||
      '  IS_MUST_UPLOAD_PROOF   NUMBER(1) NOT NULL, '||
      '  IS_MUST_CONFIRM_BYMAIL NUMBER(1) NOT NULL, '||
      '  IS_MANDATORY           NUMBER(1) NOT NULL, '||
      '  IS_PROTECTED           NUMBER(1) NOT NULL, '||
      '  IS_ENABLED             NUMBER(1) NOT NULL'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.DATA_CONSENT.ID IS 'ID';
COMMENT ON COLUMN dif.DATA_CONSENT.CONFIG_ID IS 'Configuration ID (each application can have a diferent set of consents)';
COMMENT ON COLUMN dif.DATA_CONSENT.BUSINESS_ID IS 'Business UID that identifies this consent within the configuration';
COMMENT ON COLUMN dif.DATA_CONSENT.TITLE IS 'The title';
COMMENT ON COLUMN dif.DATA_CONSENT.DESCRIPTION IS 'A full description';
COMMENT ON COLUMN dif.DATA_CONSENT.TEMPLATE_DOCUMENT_ID IS 'The proof template for the user to download and sign';
COMMENT ON COLUMN dif.DATA_CONSENT.PROFILE_ID IS 'The destination profile for the consent';
COMMENT ON COLUMN dif.DATA_CONSENT.IS_MUST_UPLOAD_PROOF IS 'Must confirm acceptance by signed document';
COMMENT ON COLUMN dif.DATA_CONSENT.IS_MUST_CONFIRM_BYMAIL IS 'Must confirm acceptance by email';
COMMENT ON COLUMN dif.DATA_CONSENT.IS_MANDATORY IS 'Is mandatory';
COMMENT ON COLUMN dif.DATA_CONSENT.IS_PROTECTED IS 'Is protected';
COMMENT ON COLUMN dif.DATA_CONSENT.IS_ENABLED IS 'Is enabled';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DATA_CONSENT'
  AND    CONSTRAINT_NAME = 'DATA_CONSENT_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT ADD CONSTRAINT DATA_CONSENT_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_DATA_CONSENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_DATA_CONSENT MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT'
  AND    INDEX_NAME = 'DATA_CONSENT_BID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.DATA_CONSENT_BID_IDX '||
                      'ON DIF.DATA_CONSENT (BUSINESS_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT'
  AND    INDEX_NAME = 'DATA_CONSENT_CONFIG_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.DATA_CONSENT_CONFIG_ID_IDX '||
                      'ON DIF.DATA_CONSENT (CONFIG_ID,BUSINESS_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- DATA CONSENT TRANSLATION table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT_TRANS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.DATA_CONSENT_TRANS( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  CONSENT_ID             NUMBER(10) NOT NULL, '||
      '  LANGUAGE_ID            VARCHAR2(10) NOT NULL, '||
      '  TITLE                  VARCHAR2(1000) NOT NULL, '||
      '  DESCRIPTION            CLOB'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.DATA_CONSENT_TRANS.ID IS 'ID';
COMMENT ON COLUMN dif.DATA_CONSENT_TRANS.CONSENT_ID IS 'The consent';
COMMENT ON COLUMN dif.DATA_CONSENT_TRANS.LANGUAGE_ID IS 'The language ID';
COMMENT ON COLUMN dif.DATA_CONSENT_TRANS.TITLE IS 'The title translation';
COMMENT ON COLUMN dif.DATA_CONSENT_TRANS.DESCRIPTION IS 'The description description';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DATA_CONSENT_TRANS'
  AND    CONSTRAINT_NAME = 'DATA_CONSENT_TRANS_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT_TRANS ADD CONSTRAINT DATA_CONSENT_TRANS_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_DATA_CONSENT_TRANS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_DATA_CONSENT_TRANS MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DATA_CONSENT_TRANS'
  AND    CONSTRAINT_NAME = 'FK_DATA_CONSENT_TRANS_CONSENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT_TRANS ADD CONSTRAINT FK_DATA_CONSENT_TRANS_CONSENT FOREIGN KEY (CONSENT_ID) REFERENCES DIF.DATA_CONSENT (ID) ON DELETE CASCADE';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- DATA CONSENT REVIEW table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT_REVIEW';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.DATA_CONSENT_REVIEW( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  CONSENT_ID             NUMBER(10) NOT NULL, '||
      '  USER_ID                VARCHAR2(255) NOT NULL, '||
      '  LAST_REVIEW_DATE       DATE NOT NULL'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.DATA_CONSENT_REVIEW.ID IS 'ID';
COMMENT ON COLUMN dif.DATA_CONSENT_REVIEW.CONSENT_ID IS 'The consent the user reviewd';
COMMENT ON COLUMN dif.DATA_CONSENT_REVIEW.USER_ID IS 'The user ID';
COMMENT ON COLUMN dif.DATA_CONSENT_REVIEW.LAST_REVIEW_DATE IS 'The last review date';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DATA_CONSENT_REVIEW'
  AND    CONSTRAINT_NAME = 'DATA_CONSENT_REVIEW_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT_REVIEW ADD CONSTRAINT DATA_CONSENT_REVIEW_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_DATA_CONSENT_REVIEW';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_DATA_CONSENT_REVIEW MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT_REVIEW'
  AND    INDEX_NAME = 'DATA_CONSENT_REV_USR_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.DATA_CONSENT_REV_USR_ID_IDX '||
                      'ON DIF.DATA_CONSENT_REVIEW (USER_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'DATA_CONSENT_REVIEW'
  AND    CONSTRAINT_NAME = 'FK_DATA_CONSENT_REVIEW_CONSENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT_REVIEW ADD CONSTRAINT FK_DATA_CONSENT_REVIEW_CONSENT FOREIGN KEY (CONSENT_ID) REFERENCES DIF.DATA_CONSENT (ID) ON DELETE CASCADE';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- USER DATA CONSENT table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_CONSENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.USER_DATA_CONSENT( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  CONSENT_ID             NUMBER(10) NOT NULL, '||
      '  USER_ID                VARCHAR2(255) NOT NULL, '||
      '  DATE_GIVEN             DATE NOT NULL,'||
      '  DATE_CONFIRMED         DATE,'||
      '  DATE_REVOKED           DATE,'||
      '  PROOF_DOCUMENT_ID      NUMBER,'||
      '  STATE                  VARCHAR2(1) NOT NULL'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.USER_DATA_CONSENT.ID IS 'ID';
COMMENT ON COLUMN dif.USER_DATA_CONSENT.CONSENT_ID IS 'The consent the user accepted';
COMMENT ON COLUMN dif.USER_DATA_CONSENT.USER_ID IS 'The user ID';
COMMENT ON COLUMN dif.USER_DATA_CONSENT.DATE_GIVEN IS 'The date the user gave consent';
COMMENT ON COLUMN dif.USER_DATA_CONSENT.DATE_CONFIRMED IS 'The date the user confirmed his consent';
COMMENT ON COLUMN dif.USER_DATA_CONSENT.DATE_REVOKED IS 'The date the user revoked the given consent';
COMMENT ON COLUMN dif.USER_DATA_CONSENT.PROOF_DOCUMENT_ID IS 'The document the user upload as proof of his consent';
COMMENT ON COLUMN dif.USER_DATA_CONSENT.STATE IS 'The consent state';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_DATA_CONSENT'
  AND    CONSTRAINT_NAME = 'USER_DATA_CONSENT_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_CONSENT ADD CONSTRAINT USER_DATA_CONSENT_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_USER_DATA_CONSENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_USER_DATA_CONSENT MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_CONSENT'
  AND    INDEX_NAME = 'USER_DATA_CONSENT_USER_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.USER_DATA_CONSENT_USER_ID_IDX '||
                      'ON DIF.USER_DATA_CONSENT (USER_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_CONSENT'
  AND    INDEX_NAME = 'USER_DATA_CON_CONSENT_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.USER_DATA_CON_CONSENT_ID_IDX '||
                      'ON DIF.USER_DATA_CONSENT (CONSENT_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_DATA_CONSENT'
  AND    CONSTRAINT_NAME = 'FK_USER_DATA_CONSENT_CONSENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_CONSENT ADD CONSTRAINT FK_USER_DATA_CONSENT_CONSENT FOREIGN KEY (CONSENT_ID) REFERENCES DIF.DATA_CONSENT (ID) ON DELETE CASCADE';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- USER DATA REQUEST table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.USER_DATA_REQUEST( '||
      '  ID                    NUMBER(10) NOT NULL, '||
      '  CONFIG_ID             VARCHAR2(255) NOT NULL, '||
      '  REQUEST_TYPE          VARCHAR2(10) NOT NULL, '||
      '  USER_ID               VARCHAR2(255) NOT NULL, '||
      '  TITLE                 VARCHAR2(500) NOT NULL,'||
      '  REQUEST_DATE          DATE NOT NULL,'||
      '  BODY                  VARCHAR2(4000),'||
      '  HANDLER_USER_ID       VARCHAR2(255), '||
      '  CLOSE_DATE            DATE,'||
      '  RESPONSE_DOCUMENT_ID  NUMBER,'||
      '  STATE                 VARCHAR2(1) NOT NULL'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.USER_DATA_REQUEST.ID IS 'ID';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.CONFIG_ID IS 'Configuration ID (each application can have a diferent set of consents)';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.REQUEST_TYPE IS 'The request type';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.USER_ID IS 'The user ID';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.TITLE IS 'The request title';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.REQUEST_DATE IS 'The request date';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.BODY IS 'The user request explanation';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.HANDLER_USER_ID IS 'The user that is handling the request';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.CLOSE_DATE IS 'When the request was closed';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.RESPONSE_DOCUMENT_ID IS 'The response document if any';
COMMENT ON COLUMN dif.USER_DATA_REQUEST.STATE IS 'The request state';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_DATA_REQUEST'
  AND    CONSTRAINT_NAME = 'USER_DATA_REQUEST_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_REQUEST ADD CONSTRAINT USER_DATA_REQUEST_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_USER_DATA_REQUEST';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_USER_DATA_REQUEST MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST'
  AND    INDEX_NAME = 'USER_DATA_REQUEST_USER_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.USER_DATA_REQUEST_USER_ID_IDX '||
                      'ON DIF.USER_DATA_REQUEST (USER_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST'
  AND    INDEX_NAME = 'USER_DATA_REQ_HANDLER_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.USER_DATA_REQ_HANDLER_ID_IDX '||
                      'ON DIF.USER_DATA_REQUEST (HANDLER_USER_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- USER DATA REQUEST COMMENT table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST_COMMENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.USER_DATA_REQUEST_COMMENT( '||
      '  ID                    NUMBER(10) NOT NULL, '||
      '  REQUEST_ID            NUMBER(10) NOT NULL, '||
      '  USER_ID               VARCHAR2(255) NOT NULL, '||
      '  COMMENT_BODY          VARCHAR2(4000) NOT NULL,'||
      '  COMMENT_DATE          DATE NOT NULL'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.USER_DATA_REQUEST_COMMENT.ID IS 'ID';
COMMENT ON COLUMN dif.USER_DATA_REQUEST_COMMENT.REQUEST_ID IS 'The request ID';
COMMENT ON COLUMN dif.USER_DATA_REQUEST_COMMENT.USER_ID IS 'The user ID';
COMMENT ON COLUMN dif.USER_DATA_REQUEST_COMMENT.COMMENT_BODY IS 'The comment';
COMMENT ON COLUMN dif.USER_DATA_REQUEST_COMMENT.COMMENT_DATE IS 'The comment date';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_DATA_REQUEST_COMMENT'
  AND    CONSTRAINT_NAME = 'USER_DATA_REQUEST_COMMENT_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_REQUEST_COMMENT ADD CONSTRAINT USER_DATA_REQUEST_COMMENT_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_USER_DATA_REQ_COMMENT';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_USER_DATA_REQ_COMMENT MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_DATA_REQUEST_COMMENT'
  AND    INDEX_NAME = 'USER_DATA_REQ_CMT_REQ_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.USER_DATA_REQ_CMT_REQ_ID_IDX '||
                      'ON DIF.USER_DATA_REQUEST_COMMENT (REQUEST_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_DATA_REQUEST_COMMENT'
  AND    CONSTRAINT_NAME = 'FK_USER_DATA_REQ_CMT_REQ';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_DATA_REQUEST_COMMENT ADD CONSTRAINT FK_USER_DATA_REQ_CMT_REQ FOREIGN KEY (REQUEST_ID) REFERENCES DIF.USER_DATA_REQUEST (ID) ON DELETE CASCADE';
  END IF;
END;
/
