package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.sql.Timestamp;
import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequest;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class UserDataRequest.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequest
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoUserDataRequestDAO extends IHibernateDAO<UserDataRequest> {

    /**
     * Obtains a new DataSet for the UserDataRequest entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserDataRequest> getUserDataRequestDataSet();

	/**
	 * Persist a UserDataRequest object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(UserDataRequest transientInstance);

	/**
	 * Updates a modified UserDataRequest in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(UserDataRequest instance);

	/**
	 * Attach an unmodified UserDataRequest instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(UserDataRequest instance);

	/**
	 * Removes a UserDataRequest instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(UserDataRequest persistentInstance);

	/**
	 * Merge a UserDataRequest instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public UserDataRequest merge(UserDataRequest detachedInstance);

	/**
	 * Finds a UserDataRequest instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public UserDataRequest findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findAll();


	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByFieldParcial(UserDataRequest.Fields field, String value);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the configId attribute with the given value
	 *
	 * @param configId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByConfigId(String configId);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the requestType attribute with the given value
	 *
	 * @param requestType to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByRequestType(String requestType);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByUserId(String userId);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByTitle(String title);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the requestDate attribute with the given value
	 *
	 * @param requestDate to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByRequestDate(Timestamp requestDate);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the body attribute with the given value
	 *
	 * @param body to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByBody(String body);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the handlerUserId attribute with the given value
	 *
	 * @param handlerUserId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByHandlerUserId(String handlerUserId);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the closeDate attribute with the given value
	 *
	 * @param closeDate to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByCloseDate(Timestamp closeDate);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the responseDocumentId attribute with the given value
	 *
	 * @param responseDocumentId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByResponseDocumentId(Long responseDocumentId);

	/**
	 * Gets a {@link List} of all UserDataRequest instances
	 * in the persistence layer than match the state attribute with the given value
	 *
	 * @param state to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataRequest> findByState(String state);
}
