package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceAreaTrans;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoReportInstanceAreaTransDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportInstanceAreaTrans.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceAreaTrans
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoReportInstanceAreaTransDAOImpl implements IAutoReportInstanceAreaTransDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportInstanceAreaTrans entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstanceAreaTrans> getReportInstanceAreaTransDataSet()
    {
        return new HibernateDataSet<ReportInstanceAreaTrans>(ReportInstanceAreaTrans.class, this, ReportInstanceAreaTrans.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoReportInstanceAreaTransDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportInstanceAreaTrans object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportInstanceAreaTrans transientInstance) {
        logger.debug("persisting ReportInstanceAreaTrans instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportInstanceAreaTrans in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportInstanceAreaTrans instance) {
        logger.debug("attaching dirty ReportInstanceAreaTrans instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportInstanceAreaTrans instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportInstanceAreaTrans instance) {
        logger.debug("attaching clean ReportInstanceAreaTrans instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportInstanceAreaTrans instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportInstanceAreaTrans persistentInstance) {
        logger.debug("deleting ReportInstanceAreaTrans instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportInstanceAreaTrans instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportInstanceAreaTrans merge(ReportInstanceAreaTrans detachedInstance) {
        logger.debug("merging ReportInstanceAreaTrans instance");
        ReportInstanceAreaTrans result = (ReportInstanceAreaTrans) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportInstanceAreaTrans instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportInstanceAreaTrans findById( java.lang.Long id) {
        logger.debug("getting ReportInstanceAreaTrans instance with id: " + id);
        ReportInstanceAreaTrans instance = (ReportInstanceAreaTrans) getSession()
                .get(ReportInstanceAreaTrans.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstanceAreaTrans> findAll() {

 		List<ReportInstanceAreaTrans> instances = new ArrayList<ReportInstanceAreaTrans>();
		logger.debug("getting all ReportInstanceAreaTrans instances");
        instances = getSession().createCriteria(ReportInstanceAreaTrans.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportInstanceAreaTrans>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportInstanceAreaTrans> findByExample(ReportInstanceAreaTrans instance) {
        logger.debug("finding ReportInstanceAreaTrans instance by example");
        List<ReportInstanceAreaTrans> results = (List<ReportInstanceAreaTrans>) getSession()
                .createCriteria(ReportInstanceAreaTrans.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstanceAreaTrans> findByFieldParcial(ReportInstanceAreaTrans.Fields field, String value) {
        logger.debug("finding ReportInstanceAreaTrans instance by parcial value: "+field+" like "+value);
        List<ReportInstanceAreaTrans> results = (List<ReportInstanceAreaTrans>) getSession()
                .createCriteria(ReportInstanceAreaTrans.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than match the language attribute with the given value
	 *
	 * @param language to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaTrans> findByLanguage(String language) {
        ReportInstanceAreaTrans instance = new ReportInstanceAreaTrans();

        instance.setLanguage(language);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than match the content attribute with the given value
	 *
	 * @param content to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaTrans> findByContent(String content) {
        ReportInstanceAreaTrans instance = new ReportInstanceAreaTrans();

        instance.setContent(content);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceAreaTrans instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaTrans> findByTitle(String title) {
        ReportInstanceAreaTrans instance = new ReportInstanceAreaTrans();

        instance.setTitle(title);

        return findByExample(instance);
    }

}

